/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.replacetoken.helpers;

import com.ibm.urbancode.zos.common.util.StringHelper;
import java.util.Map;

public class TokenReplacer {
    private int replacedTokenCount = 0;
    private String datasetContent;
    private final Map<String, String> replaceTokens;

    private TokenReplacer(String datasetContent, Map<String, String> replaceTokens) {
        this.datasetContent = datasetContent;
        this.replaceTokens = replaceTokens;
    }

    public static TokenReplacer replace(String datasetContent, Map<String, String> replaceTokens) {
        TokenReplacer tokenReplacer = new TokenReplacer(datasetContent, replaceTokens);
        tokenReplacer.replaceTokens();
        return tokenReplacer;
    }

    public void replaceTokens() {
        for (String token : this.replaceTokens.keySet()) {
            String value = this.replaceTokens.get(token);
            int matchCount = StringHelper.countMatches(this.datasetContent, token);
            if (matchCount <= 0) continue;
            this.replacedTokenCount += matchCount;
            this.datasetContent = this.datasetContent.replace(token, value);
        }
    }

    public int getReplacedTokenCount() {
        return this.replacedTokenCount;
    }

    public String getReplacedContent() {
        return this.datasetContent;
    }
}

