/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.common;

import com.ibm.urbancode.zos.common.util.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TarUtil {
    private static final String UTF_8 = "UTF-8";
    private static final int BUFFER_SIZE = 8192;

    private TarUtil() {
    }

    public static void untar(String outputDir, String zipFilePath) throws IOException {
        Console.printProcessOutput("Extracting files from " + zipFilePath);
        try (InputStream inputStream = Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]);
             TarArchiveInputStream tarIn = new TarArchiveInputStream(inputStream, UTF_8);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                Console.printProcessOutput(entry.getName());
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory: " + outputFile);
                }
                File parentDir = outputFile.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new IOException("Failed to create parent directory: " + parentDir);
                }
                TarUtil.writeToOutputStream(outputFile, tarIn);
            }
        }
    }

    private static void writeToOutputStream(File outputFile, TarArchiveInputStream tarIn) throws IOException {
        try (OutputStream out = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = tarIn.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }
}

