/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.mappings;

import com.urbancode.air.plugin.command.version.mappings.HfsMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HfsMappingResolver {
    private HfsMappingResolver() {
    }

    public static Map<String, String> resolve(HfsMapper mapper, Collection<String> packageContainers) {
        Map<String, String> srcTargetMapWithoutRegEx = mapper.getSrcTargetMapWithoutRegEx();
        Map<String, String> srcTargetMapWithRegEx = mapper.getSrcTargetMapWithRegEx();
        HashMap<String, String> resolvedMap = new HashMap<String, String>();
        StringBuilder unresolvedContainers = new StringBuilder();
        for (String packageContainer : packageContainers) {
            if (srcTargetMapWithoutRegEx.containsKey(packageContainer)) {
                resolvedMap.put(packageContainer, srcTargetMapWithoutRegEx.get(packageContainer));
                continue;
            }
            Optional<String> mappedTarget = HfsMappingResolver.getTargetContainer(packageContainer, srcTargetMapWithRegEx);
            if (mappedTarget.isPresent()) {
                resolvedMap.put(packageContainer, mappedTarget.get());
                continue;
            }
            unresolvedContainers.append(System.lineSeparator()).append(packageContainer);
        }
        String unresolvedContainersString = unresolvedContainers.toString();
        if (unresolvedContainersString.isEmpty()) {
            return resolvedMap;
        }
        throw new IllegalArgumentException("Missing mapping rules for below HFS directories: " + unresolvedContainers);
    }

    private static Optional<String> getTargetContainer(String sourceContainer, Map<String, String> srcTargetMapWithWildcard) {
        for (String sourceWithRegEx : srcTargetMapWithWildcard.keySet()) {
            if (!sourceContainer.matches(sourceWithRegEx)) continue;
            return Optional.of(srcTargetMapWithWildcard.get(sourceWithRegEx));
        }
        return Optional.empty();
    }
}

