/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.Check;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

final class CharSequenceReader
extends Reader {
    private CharSequence sequence;
    private int index;
    private int mark;

    CharSequenceReader(CharSequence sequence) {
        this.sequence = Check.nonNull(sequence, "sequence");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer buffer) throws IOException {
        Check.nonNull(buffer, "buffer");
        int result = -1;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            int sequenceLength = this.sequence.length();
            if (this.index < sequenceLength) {
                int count = Math.min(buffer.remaining(), sequenceLength - this.index);
                for (int i = 0; i < count; ++i) {
                    buffer.put(this.sequence.charAt(this.index));
                    ++this.index;
                }
                result = count;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        int result = -1;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            if (this.index < this.sequence.length()) {
                result = this.sequence.charAt(this.index);
                ++this.index;
            }
        }
        return result;
    }

    @Override
    public int read(char[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        Check.nonNull(buffer, "buffer");
        Check.indexRange(buffer.length, offset, length);
        int result = -1;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            int sequenceLength = this.sequence.length();
            if (this.index < sequenceLength) {
                int count = Math.min(sequenceLength - this.index, length);
                for (int i = 0; i < count; ++i) {
                    buffer[i + offset] = this.sequence.charAt(this.index);
                    ++this.index;
                }
                result = count;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long count) throws IOException {
        int result;
        Check.nonNegative(count, "count");
        Object object = this.lock;
        synchronized (object) {
            result = (int)Math.min(count, (long)(this.sequence.length() - this.index));
            this.index += result;
        }
        return result;
    }

    @Override
    public boolean ready() throws IOException {
        this.checkOpen();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        Check.nonNegative(readAheadLimit, "readAheadLimit");
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            this.mark = this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            this.index = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.sequence = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpen() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.sequence == null) {
                throw new IOException("Reader closed");
            }
        }
    }
}

