/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.urbancode.commons.util.immutable.AImmutableSet;
import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.immutable.IImmutableSet;
import com.urbancode.commons.util.immutable.ImmutableHashMap;
import java.util.Collection;

public class ImmutableHashSet<T>
extends AImmutableSet<T> {
    private static final ImmutableHashSet<?> EMPTY = new ImmutableHashSet(ImmutableHashMap.empty());

    public static <T> ImmutableHashSet<T> empty() {
        return EMPTY;
    }

    public static <T> ImmutableHashSet<T> create(T ... init) {
        IImmutableSet<T> ret = ImmutableHashSet.empty();
        for (T element : init) {
            ret = ret.with((Object)element);
        }
        return ret;
    }

    public static <T> ImmutableHashSet<T> create(Collection<? extends T> init) {
        IImmutableSet<T> ret = ImmutableHashSet.empty();
        for (T key : init) {
            ret = ret.with((Object)key);
        }
        return ret;
    }

    ImmutableHashSet(IImmutableMap<T, T> impl) {
        super(impl);
    }

    @Override
    public ImmutableHashSet<T> without(Object key) {
        if (this.contains(key)) {
            return new ImmutableHashSet(this.impl.without(key));
        }
        return this;
    }

    @Override
    public ImmutableHashSet<T> with(T o) {
        if (this.contains(o)) {
            return this;
        }
        return new ImmutableHashSet<T>(this.impl.with(o, o));
    }

    @Override
    public ImmutableHashSet<T> union(Collection<? extends T> coll) {
        IImmutableSet<T> result = this;
        for (T t : coll) {
            result = result.with((Object)t);
        }
        return result;
    }

    @Override
    public ImmutableHashSet<T> difference(Collection<?> coll) {
        IImmutableSet<T> result = this;
        for (Object t : coll) {
            result = result.without(t);
        }
        return result;
    }

    @Override
    public ImmutableHashSet<T> intersection(Collection<?> coll) {
        IImmutableSet<T> result = this;
        for (Object t : this) {
            if (coll.contains(t)) continue;
            result = result.without(t);
        }
        return result;
    }
}

