/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.airplugins;

import com.urbancode.air.securedata.Base64Codec;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.SecretContainerImpl;
import com.urbancode.air.securedata.SecureBlob;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Properties;

public class AirPluginTool {
    private static final String UCD_ENCRYPT_PROPERTIES_ENV_VAR = "UCD_USE_ENCRYPTED_PROPERTIES";
    private static final String UCD_DEBUG_ENCRYPTED_PROPERTIES = "UCD_DEBUG_ENCRYPTED_PROPERTIES";
    private static final String UCD_SECRET_VAR = "ucd.properties.secret";
    private static final String UCD_SUITE_VAR = "ucd.properties.suite";
    static final String PLUGIN_USE_SECURE_OUTPUT_PROPERTIES_ENV_VAR = "PLUGIN_USE_SECURE_OUTPUT_PROPERTIES";
    static final String SECURE_NAME_SUFFIX = ".$secure";
    private final String inPropsFile;
    private final String outPropsFile;
    private final boolean isWindows;
    private final boolean enableSecureOutputProperties;
    private final Map<String, String> env;
    private final PrintStream err;
    private Properties outProps;
    private boolean hasReadStdIn;
    private String secret;
    private String suite;

    public AirPluginTool(String inPropsFile, String outPropsFile) {
        this(inPropsFile, outPropsFile, System.getProperty("os.name").toLowerCase().contains("windows"), System.getenv(), System.err);
    }

    protected AirPluginTool(String inPropsFile, String outPropsFile, boolean isWindows, Map<String, String> env, PrintStream err) {
        this.inPropsFile = inPropsFile;
        this.outPropsFile = outPropsFile;
        this.isWindows = isWindows;
        this.env = env;
        this.err = err;
        this.outProps = new Properties();
        this.enableSecureOutputProperties = Boolean.parseBoolean(this.getenv(PLUGIN_USE_SECURE_OUTPUT_PROPERTIES_ENV_VAR));
    }

    public Properties getStepProperties() throws IOException, GeneralSecurityException {
        return this.getStepProperties(this.getEncKey(), this.getSuite());
    }

    public void setOutputProperty(String name, String value) {
        this.setOutputProperty(name, value, false);
    }

    public void setOutputProperty(String name, String value, boolean secure) {
        if (!secure) {
            this.outProps.setProperty(name, value);
        } else if (this.isSecureOutputPropertySupported()) {
            this.outProps.setProperty(name + SECURE_NAME_SUFFIX, value);
        } else {
            this.err.println("Setting a secure output property is not supported: " + name);
        }
    }

    public boolean isSecureOutputPropertySupported() {
        return this.enableSecureOutputProperties;
    }

    public void storeOutputProperties() throws IOException, GeneralSecurityException {
        this.setOutputProperties(this.getEncKey(), this.getSuite());
    }

    public String getAuthToken() {
        String authToken = this.getenv("AUTH_TOKEN");
        return "{\"token\" : \"" + authToken + "\"}";
    }

    public String getAuthTokenUsername() {
        return "PasswordIsAuthToken";
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    private Properties getStepProperties(String encSecret, String suite) throws IOException, GeneralSecurityException {
        byte[] sec = this.decodeSecret(encSecret);
        Properties props = new Properties();
        FileInputStream inStream = new FileInputStream(this.inPropsFile);
        if (sec == null) {
            this.loadProperties(props, inStream);
        } else {
            SecretContainer secret = this.newSecretContainer(sec, suite);
            this.loadEncryptedProperties(secret, props, inStream);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEncryptedProperties(SecretContainer secret, Properties props, InputStream inStream) throws IOException, GeneralSecurityException {
        try {
            SecureBlob blob = this.fromEncryptedBytes(secret, inStream);
            this.loadProperties(props, new ByteArrayInputStream(blob.get()));
        }
        finally {
            this.close(inStream);
        }
    }

    private void loadProperties(Properties props, InputStream inStream) {
        try {
            props.load(inStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.close(inStream);
        }
    }

    private String getEncKey() throws IOException {
        this.readStdInIfNeeded();
        return this.secret;
    }

    private String getSuite() throws IOException {
        this.readStdInIfNeeded();
        return this.suite;
    }

    private void readStdInIfNeeded() throws IOException {
        if (!this.hasReadStdIn) {
            boolean debugEnc = Boolean.valueOf(this.getenv(UCD_DEBUG_ENCRYPTED_PROPERTIES));
            boolean useEnc = Boolean.valueOf(this.getenv(UCD_ENCRYPT_PROPERTIES_ENV_VAR));
            Properties props = new Properties();
            if (useEnc) {
                props.load(System.in);
                this.secret = props.getProperty(UCD_SECRET_VAR);
                this.suite = props.getProperty(UCD_SUITE_VAR);
                this.hasReadStdIn = true;
                if (debugEnc) {
                    byte[] decoded = this.decodeSecret(this.secret);
                    if (decoded != null) {
                        System.err.println("DEBUG: secret size=" + decoded.length * 8);
                    } else {
                        System.err.println("DEBUG: no secret");
                    }
                    if (this.suite != null) {
                        System.err.println("DEBUG: suite=" + this.suite);
                    } else {
                        System.err.println("DEBUG: no suite");
                    }
                }
            } else if (debugEnc) {
                System.err.println("DEBUG: properties not encrypted");
            }
        }
    }

    private byte[] decodeSecret(String secret) {
        if (secret != null && !secret.trim().equals("")) {
            return this.getBase64Codec().decodeFromString(secret);
        }
        return null;
    }

    private void setOutputProperties(String encSecret, String suite) throws IOException, GeneralSecurityException {
        byte[] sec = this.decodeSecret(encSecret);
        FileOutputStream os = new FileOutputStream(this.outPropsFile);
        if (sec == null) {
            this.writePropertiesFile(this.outProps, os);
        } else {
            SecretContainer secretCon = this.newSecretContainer(sec, suite);
            this.writeEncryptedPropertiesFile(secretCon, this.outProps, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEncryptedPropertiesFile(SecretContainer secret, Properties props, OutputStream os) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writePropertiesFile(props, baos);
        try {
            SecureBlob blob = this.fromUnencryptedBytes(secret, baos.toByteArray());
            this.close(baos);
            os.write(blob.getEncryptedBytes());
        }
        finally {
            this.close(os);
        }
    }

    private void writePropertiesFile(Properties props, OutputStream os) throws IOException {
        try {
            props.store(os, "");
        }
        finally {
            this.close(os);
        }
    }

    private Base64Codec getBase64Codec() {
        return new Base64Codec();
    }

    private SecureBlob fromUnencryptedBytes(SecretContainer secret, byte[] os) throws GeneralSecurityException {
        return SecureBlob.fromUnencryptedBytes((SecretContainer)secret, (byte[])os);
    }

    private SecureBlob fromEncryptedBytes(SecretContainer secret, InputStream is) throws IOException, GeneralSecurityException {
        return SecureBlob.fromEncryptedBytes((SecretContainer)secret, (byte[])IO.read((InputStream)is));
    }

    private SecretContainer newSecretContainer(byte[] secret, String suite) {
        if (suite == null) {
            return new SecretContainerImpl(secret);
        }
        return new SecretContainerImpl(secret, suite);
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getenv(String key) {
        String value = this.env.get(key);
        if (this.isBlank(value)) {
            return null;
        }
        return value.trim();
    }

    private boolean isBlank(String s) {
        int len;
        if (s == null || (len = s.length()) == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }
}

