/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.hfs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.deployment.common.DeltaManifest;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.ContainerMap;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import com.urbancode.air.plugin.command.version.deployment.DeltaDeployedXml;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.apache.tools.ant.types.FileSet;

public class BackupFilesTask
extends Task {
    private static final String TEMP_INCLUDES_FILE = "deltaDeployed.asHFSFileSet";
    private static final String HFS_DIR = "HFS";
    private String versionWorkDir;
    private boolean oldVersionIdentifier;
    private final DeltaManifest deltaManifest = new DeltaManifest();
    private static boolean skipBackup = false;

    public static void generateDeltaDeployedXmlFile(boolean oldVersionIdentifier, String componentVersionWorkingDir) {
        skipBackup = true;
        BackupFilesTask.executeTask(oldVersionIdentifier, componentVersionWorkingDir);
    }

    public static void executeTask(boolean oldVersionIdentifier, String componentVersionWorkingDir) {
        Project ant = new Project();
        ant.init();
        Taskdef taskdef = (Taskdef)ant.createTask("taskdef");
        taskdef.setName("backupHFSFiles");
        taskdef.setClassname("com.ibm.team.enterprise.deployment.hfs.BackupFilesTask");
        taskdef.execute();
        BackupFilesTask backupFilesTask = (BackupFilesTask)ant.createTask("backupHFSFiles");
        backupFilesTask.setOldVersionIdentifier(oldVersionIdentifier);
        backupFilesTask.setVersionWorkDir(componentVersionWorkingDir);
        backupFilesTask.execute();
    }

    @Override
    public void execute() throws BuildException {
        try {
            String targetDirPath;
            String deltaDeployedXmlFilePath = this.versionWorkDir + File.separator + "deltaDeployed.xml";
            if (FileHelper.isFileExist(deltaDeployedXmlFilePath)) {
                this.addMvsContainers(deltaDeployedXmlFilePath);
            }
            ContainerMap containerMap = ContainerMap.from((String)(this.versionWorkDir + File.separator + "containerMapperHFS.xml"));
            String manifestFilePath = this.versionWorkDir + File.separator + "packageManifest_deploy.xml";
            PackageManifest packageManifest = PackageManifest.from((String)manifestFilePath);
            this.deltaManifest.setVersion(packageManifest.getVersion());
            List<Container> deployPackageContainers = this.getHfsContainers(packageManifest.getAddedContainers());
            List<Container> deletedPackageContainers = this.getHfsContainers(packageManifest.getDeletedContainers());
            for (Container deployPackageContainer : deployPackageContainers) {
                targetDirPath = this.getTargetDirPath(containerMap, deployPackageContainer.getSourceName());
                Optional<RollbackContainer> createdRollbackContainer = this.getCreatedRollbackContainer(deployPackageContainer, targetDirPath);
                createdRollbackContainer.ifPresent(this.deltaManifest::addCreatedContainer);
                Optional<RollbackContainer> updatedRollbackContainer = this.getUpdatedRollbackContainer(deployPackageContainer, targetDirPath);
                if (!updatedRollbackContainer.isPresent()) continue;
                this.deltaManifest.addUpdatedContainer(updatedRollbackContainer.get());
                List<String> backupFiles = this.getBackupFilesFromUpdatedContainer(updatedRollbackContainer.get());
                this.addBackupFilesToArchive(backupFiles, targetDirPath, deployPackageContainer.getSourceName());
            }
            for (Container deletedPackageContainer : deletedPackageContainers) {
                targetDirPath = this.getTargetDirPath(containerMap, deletedPackageContainer.getSourceName());
                RollbackContainer deletedRollbackContainer = this.getDeletedRollbackContainer(deletedPackageContainer, targetDirPath);
                this.deltaManifest.addDeletedContainer(deletedRollbackContainer);
                List<String> backupFiles = this.getBackupFilesFromDeletedContainer(deletedRollbackContainer);
                if (backupFiles.isEmpty()) continue;
                this.addBackupFilesToArchive(backupFiles, targetDirPath, deletedPackageContainer.getSourceName());
            }
            String deltaDeployedXml = DeltaDeployedXml.from(this.deltaManifest);
            FileHelper.writeStringToFile(deltaDeployedXml, deltaDeployedXmlFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    private void addMvsContainers(String deltaDeployedXmlFilePath) throws XMLStreamException, IOException {
        RollbackManifest rollbackManifest = RollbackManifest.from((String)deltaDeployedXmlFilePath);
        this.deltaManifest.addAllCreatedContainers(rollbackManifest.getCreatedContainers());
        this.deltaManifest.addAllUpdatedContainers(rollbackManifest.getUpdatedContainers());
        this.deltaManifest.addAllDeletedContainers(rollbackManifest.getDeletedContainers());
    }

    private Optional<RollbackContainer> getCreatedRollbackContainer(Container deployPackageContainer, String targetDirPath) {
        List<RollbackResource> createdResources = this.getCreatedRollbackResources(deployPackageContainer.getResources(), targetDirPath);
        if (createdResources.isEmpty()) {
            return Optional.empty();
        }
        RollbackContainer rollbackContainer = new RollbackContainer(deployPackageContainer.getSourceName(), ContainerType.DIRECTORY);
        if (FileHelper.isDirectoryNotExist(targetDirPath)) {
            rollbackContainer.setMissing();
        }
        rollbackContainer.addResources(createdResources);
        if (deployPackageContainer.getDeployType() != null) {
            rollbackContainer.setDeployType(deployPackageContainer.getDeployType());
        }
        return Optional.of(rollbackContainer);
    }

    private Optional<RollbackContainer> getUpdatedRollbackContainer(Container deployPackageContainer, String targetDirPath) {
        List<RollbackResource> updatedResources = this.getUpdatedRollbackResources(deployPackageContainer.getResources(), targetDirPath);
        if (updatedResources.isEmpty()) {
            return Optional.empty();
        }
        RollbackContainer rollbackContainer = new RollbackContainer(deployPackageContainer.getSourceName(), ContainerType.DIRECTORY);
        rollbackContainer.addResources(updatedResources);
        if (deployPackageContainer.getDeployType() != null) {
            rollbackContainer.setDeployType(deployPackageContainer.getDeployType());
        }
        return Optional.of(rollbackContainer);
    }

    private RollbackContainer getDeletedRollbackContainer(Container container, String targetDirPath) {
        RollbackContainer rollbackContainer = new RollbackContainer(container.getSourceName(), ContainerType.DIRECTORY);
        if (FileHelper.isDirectoryNotExist(targetDirPath)) {
            rollbackContainer.setMissing();
        }
        if (container.getDeployType() != null) {
            rollbackContainer.setDeployType(container.getDeployType());
        }
        List<RollbackResource> deletedResources = this.getDeletedRollbackResources(container.getResources(), targetDirPath);
        rollbackContainer.addResources(deletedResources);
        return rollbackContainer;
    }

    private List<String> getBackupFilesFromUpdatedContainer(RollbackContainer updatedContainer) {
        return updatedContainer.getResources().stream().map(RollbackResource::getName).collect(Collectors.toList());
    }

    private List<String> getBackupFilesFromDeletedContainer(RollbackContainer rollbackContainer) {
        if (rollbackContainer.isMissing()) {
            return new ArrayList<String>();
        }
        return rollbackContainer.getResources().stream().filter(rollbackResource -> !rollbackResource.isMissing()).map(RollbackResource::getName).collect(Collectors.toList());
    }

    private List<Container> getHfsContainers(List<Container> packageManifest) {
        return packageManifest.stream().filter(Container::isDirectory).collect(Collectors.toList());
    }

    private List<RollbackResource> getCreatedRollbackResources(Collection<Resource> packageContainerResources, String targetDirPath) {
        return packageContainerResources.stream().map(resource -> this.createRollbackResource(targetDirPath, (Resource)resource)).filter(RollbackResource::isMissing).collect(Collectors.toList());
    }

    private List<RollbackResource> getUpdatedRollbackResources(Collection<Resource> packageContainerResources, String targetDirPath) {
        return packageContainerResources.stream().map(resource -> this.createRollbackResource(targetDirPath, (Resource)resource)).filter(rollbackResource -> !rollbackResource.isMissing()).collect(Collectors.toList());
    }

    private List<RollbackResource> getDeletedRollbackResources(Collection<Resource> packageContainerResources, String targetDirPath) {
        return packageContainerResources.stream().map(resource -> this.createRollbackResource(targetDirPath, (Resource)resource)).collect(Collectors.toList());
    }

    private RollbackResource createRollbackResource(String targetDirPath, Resource resource) {
        RollbackResource rollbackResource = new RollbackResource(resource.getName(), "file");
        String resourceFilePath = targetDirPath + File.separator + resource.getName();
        if (FileHelper.isFileNotExist(resourceFilePath)) {
            rollbackResource.setMissing();
        }
        if (resource.getResourceDeployType() != null) {
            rollbackResource.setDeployType(resource.getResourceDeployType());
        }
        return rollbackResource;
    }

    private String getTargetDirPath(ContainerMap containerMap, String sourceContainerName) throws IOException {
        String containerName = File.separator + sourceContainerName;
        File targetOutputsDir = new File((String)containerMap.getTargets(containerName).get(0));
        return this.oldVersionIdentifier ? targetOutputsDir.getCanonicalPath() + containerName : targetOutputsDir.getCanonicalPath();
    }

    private void addBackupFilesToArchive(List<String> backupFiles, String targetDirPath, String sourceContainerName) throws IOException {
        if (skipBackup) {
            return;
        }
        File includesFile = new File(this.versionWorkDir + File.separator + TEMP_INCLUDES_FILE);
        this.writeFilesToBackupInIncludesFile(backupFiles, includesFile);
        FileSet fileSet = this.createFileSet(targetDirPath, includesFile);
        this.printFilesLog(targetDirPath, fileSet);
        File backupZipFile = new File(this.versionWorkDir, "backup.zip");
        HFSUtil.createTar(Collections.singletonList(fileSet), (File)backupZipFile, (String)(HFS_DIR + File.separator + sourceContainerName), (Project)this.getProject());
        if (includesFile.exists() && !includesFile.delete()) {
            throw new RuntimeException("Failed to delete temporary includes File " + includesFile.getCanonicalPath());
        }
    }

    private void writeFilesToBackupInIncludesFile(List<String> backupFiles, File includesFile) throws IOException {
        try (OutputStream os = Files.newOutputStream(includesFile.toPath(), new OpenOption[0]);
             OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);
             PrintWriter includesFileWriter = new PrintWriter(new BufferedWriter(osw));){
            for (String backupFile : backupFiles) {
                includesFileWriter.println(backupFile);
            }
        }
    }

    private FileSet createFileSet(String targetDirPath, File includesFile) {
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(new File(targetDirPath));
        fileSet.setIncludesfile(includesFile);
        return fileSet;
    }

    private void printFilesLog(String targetDirPath, FileSet fileSet) {
        this.printLine("\tAdding following files from " + targetDirPath + " to backup");
        fileSet.stream().forEach(resource -> this.printLine("\t\t" + resource.getName()));
    }

    private void printLine(String s) {
        Echo echo = new Echo();
        echo.setMessage(s);
        echo.execute();
    }

    public void setVersionWorkDir(String versionWorkDir) {
        this.versionWorkDir = versionWorkDir;
    }

    public void setOldVersionIdentifier(boolean oldVersionIdentifier) {
        this.oldVersionIdentifier = oldVersionIdentifier;
    }
}

