/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.common.jes;

import com.urbancode.air.plugin.command.jcl.common.jes.JmonException;

class JmonProtocol {
    private static final JmonProtocol CLIENT_PROTOCOL_LEVEL = new JmonProtocol("01", "12");
    private static final String TEMPLATE = "ACKNOWLEDGEmmvnn";
    private static final String ACK = "ACKNOWLEDGE";
    private final String major;
    private final String minor;

    public JmonProtocol(String major, String minor) {
        this.major = major;
        this.minor = minor;
    }

    public JmonProtocol(String level) {
        this.major = level.substring(0, 2);
        this.minor = level.substring(2);
    }

    public String getMajorLevel() {
        return this.major;
    }

    public String getMinorLevel() {
        return this.minor;
    }

    public String getLevel() {
        return this.major + this.minor;
    }

    public static String getConnectCommand() {
        return "CONNECT" + CLIENT_PROTOCOL_LEVEL.getMajorLevel() + " v" + CLIENT_PROTOCOL_LEVEL.getMinorLevel();
    }

    public static JmonProtocol from(String connectResponse) {
        if (connectResponse.trim().isEmpty()) {
            throw new JmonException("Acknowledgement is empty.");
        }
        if (!connectResponse.startsWith(ACK) || connectResponse.length() < TEMPLATE.length()) {
            throw new JmonException("Invalid acknowledgement received - " + connectResponse);
        }
        int indexOfV = connectResponse.indexOf(118);
        int endIndex = connectResponse.indexOf(32);
        endIndex = endIndex > 0 ? endIndex : connectResponse.length();
        JmonProtocol protocol = new JmonProtocol(connectResponse.substring(ACK.length(), indexOfV), connectResponse.substring(indexOfV + 1, endIndex));
        if (CLIENT_PROTOCOL_LEVEL.isEarlierThan(protocol)) {
            throw new JmonException("Unsupported JMON server protocol level " + protocol.getLevel());
        }
        return protocol;
    }

    public boolean isLaterThan(JmonProtocol base) {
        if (base == null) {
            return true;
        }
        return this.getLevel().compareTo(base.getLevel()) > 0;
    }

    public boolean isEarlierThan(JmonProtocol base) {
        if (base == null) {
            return false;
        }
        return this.getLevel().compareTo(base.getLevel()) < 0;
    }

    public String toString() {
        return this.major + "v" + this.minor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JmonProtocol)) {
            return false;
        }
        return this.getLevel().equals(((JmonProtocol)o).getLevel());
    }
}

