/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.submit;

import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

class PaginationPrintStream
extends PrintStream {
    private static final String STDOUT_TXT = "stdOut.txt";
    private static final int MAX_LINE_COUNT_FOR_FIRST_PAGE = 999;
    private static final int MAX_LINE_COUNT_FOR_LATER_PAGES = 1000;
    private static final String NEW_LINE = "\n";
    private int stdOutFileLineCount;

    public PaginationPrintStream(String stdOutDirectoryPath) throws IOException {
        super(System.out, true);
        String stdOutFilePath = stdOutDirectoryPath + File.separator + STDOUT_TXT;
        this.stdOutFileLineCount = FileHelper.getFileLineCount(stdOutFilePath);
    }

    @Override
    public void print(String s) {
        super.print(s);
    }

    @Override
    public void println(String str) {
        if (str == null) {
            str = "";
        } else if (str.contains(NEW_LINE)) {
            this.stdOutFileLineCount += StringHelper.countMatches(str, NEW_LINE);
        } else if (str.contains("=================================== Submitting")) {
            int noOfBlankLinesToBeAdded = this.determineNoOfBlankLinesToBeAdded(this.stdOutFileLineCount);
            this.stdOutFileLineCount += noOfBlankLinesToBeAdded;
            super.print(this.getBlankLines(noOfBlankLinesToBeAdded));
        }
        ++this.stdOutFileLineCount;
        super.println(str);
    }

    private int determineNoOfBlankLinesToBeAdded(int stdOutFileLineCount) {
        boolean isLastPageCompletelyFilled;
        if (stdOutFileLineCount <= 999) {
            return 999 - stdOutFileLineCount;
        }
        int noOfLinesOverflowingFirstPage = stdOutFileLineCount - 999;
        boolean bl = isLastPageCompletelyFilled = noOfLinesOverflowingFirstPage % 1000 == 0;
        if (isLastPageCompletelyFilled) {
            return 0;
        }
        int noOfLinesFilledOnLastPage = noOfLinesOverflowingFirstPage % 1000;
        return 1000 - noOfLinesFilledOnLastPage;
    }

    private String getBlankLines(int noOfBlankLinesToBeAdded) {
        StringBuilder stringBuilder = new StringBuilder(noOfBlankLinesToBeAdded);
        for (int i = 0; i < noOfBlankLinesToBeAdded; ++i) {
            stringBuilder.append(NEW_LINE);
        }
        return stringBuilder.toString();
    }
}

