/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.mappings;

import com.urbancode.air.plugin.command.version.mappings.DatasetMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DatasetMappingResolver {
    private DatasetMappingResolver() {
    }

    public static Map<String, Set<String>> resolve(DatasetMapper mapper, Collection<String> packageContainers) {
        Map<String, Set<String>> srcTargetMapWithoutRegEx = mapper.getSrcTargetMapWithoutRegEx();
        Map<String, Set<String>> srcTargetMapWithRegEx = mapper.getSrcTargetMapWithRegEx();
        HashMap<String, Set<String>> resolvedMap = new HashMap<String, Set<String>>();
        StringBuilder unresolvedContainers = new StringBuilder();
        for (String packageContainer : packageContainers) {
            if (srcTargetMapWithoutRegEx.containsKey(packageContainer)) {
                resolvedMap.put(packageContainer, srcTargetMapWithoutRegEx.get(packageContainer));
                continue;
            }
            Set<String> mappedTargets = DatasetMappingResolver.getTargetsMapped(packageContainer, srcTargetMapWithRegEx);
            if (mappedTargets.isEmpty()) {
                unresolvedContainers.append(System.lineSeparator()).append(packageContainer);
                continue;
            }
            resolvedMap.put(packageContainer, mappedTargets);
        }
        String unresolvedDatasets = unresolvedContainers.toString();
        if (!unresolvedDatasets.isEmpty()) {
            throw new IllegalArgumentException("Missing mapping rules for below MVS datasets : " + unresolvedDatasets);
        }
        return resolvedMap;
    }

    private static Set<String> getTargetsMapped(String sourceContainer, Map<String, Set<String>> srcTargetMapWithWildcard) {
        for (String sourceWithRegEx : srcTargetMapWithWildcard.keySet()) {
            if (!sourceContainer.matches(sourceWithRegEx)) continue;
            return srcTargetMapWithWildcard.get(sourceWithRegEx);
        }
        return new HashSet<String>();
    }
}

