/* REXX */
/*%STUB CALLCMD*/
/*********************************************************************/
/* Copyright:    Licensed Materials - Property of IBM and/or HCL     */
/*                                                                   */
/*        Copyright IBM Corporation. All rights reserved             */
/*        Copyright HCL Technologies limited. All rights reserved    */
/*                                                                   */
/*        US Government Users Restricted Rights -                    */
/*        Use, duplication or disclosure restricted by               */
/*        GSA ADP Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/
parse arg actionDataset

CODE_8 = 8

say ""
say "   ******   Start of Process   ******   "
say ""
/* Read Action records into a stem variable */
drop actionRecords.
Address TSO "ALLOC F(ACTNDSN)  DA('"actionDataset"') SHR REUSE"
Address TSO "EXECIO * DISKR ACTNDSN (STEM actionRecords. FINIS)"
exec_RC = rc
x = Msg('off')
    Address TSO "FREE F(ACTNDSN)"
x = Msg('on')
if exec_RC <> 0 then do
    say " [Error] EXECIO failed for dataset" actionDataset "with rc" exec_RC
    call ExitProgram(exec_RC)
end

/* Main Process */
/* Reading Action dataset records one by one and process it */
/* Note : The offset starts from 2nd line as 1st line is header */
do offset = 1 to actionRecords.0
    parse upper var actionRecords.offset DSNtype ";" Action ";" SrceDSN ";" TargDSN ";" PDSmem .
    Select
      when ( Action == "UPDATE" & DSNtype == "PDS" ) then do
         call CreateDatasetIfDoesNotExist

         say 'Copying PDS members to' TargDSN
         call CopyPdsMembers
      end

      when ( Action == "UPDATE" & DSNtype == "SEQ" ) then do
         call CreateDatasetIfDoesNotExist

         say 'Copying sequential dataset to' TargDSN
         call CopySequentialDataset
      end
      otherwise do
        say " [Error] Invalid Action record found -" actionRecords.offset
        Call ExitProgram(CODE_8)
      end
    end
end

   say ""
   say "   ******   End of Process   ******   "
   say ""

exit /* End of Program */

CopySequentialDataset:

   /* IEBGENER to Update Data  */
   Address TSO "ALLOC F(SYSPRINT) NEW REUSE"
   Address TSO "ALLOC F(SYSUT1)  DA('"SrceDSN"') SHR REUSE"
   Address TSO "ALLOC F(SYSUT2) DA('"TargDSN"') SHR REUSE"
   Address TSO "ALLOC F(SYSIN) DUMMY REUSE "
   Address ISPEXEC "ISPEXEC SELECT PGM(IEBGENER)"
   Copy_rc = rc

   Address TSO  "EXECIO * DISKR SYSPRINT (FINIS STEM sysmsgs."

   x = Msg('off')
       Address TSO "FREE F(SYSIN,SYSPRINT,SYSUT1,SYSUT2)"
   x = Msg('on')

   If Copy_rc <> 0 Then do
      /* Display SYSTEM message from IEBGENER in case of failure */
      Do xmit = 1 to sysmsgs.0
          Say Strip(sysmsgs.xmit)
      End
      call ExitProgram(Copy_rc)
   End

return

CopyPdsMembers:
 /* IEBCOPY to add/replace MEMBERS into LOAD/BINARY type PDS */
   Address TSO "ALLOC F(SYSPRINT) NEW REUSE"
   Address TSO "ALLOC F(INDD)  DA('"SrceDSN"') SHR REUSE"
   Address TSO "ALLOC F(OUTDD) DA('"TargDSN"') SHR REUSE"
   Address TSO "ALLOC F(SYSIN) NEW REUSE"

   Address TSO "ALLOC F(SYSUT4) NEW" ||,
                   " CYLINDERS UNIT(SYSALLDA) SPACE(5 10)"

 /**********************************************************
    From zOS 2.1 onwards we can use the COPYGROUP for alias
    or if data set is a PDSE we can use COPYGRP for alias
 ***********************************************************/
   DROP SYSLINE.

   SYSLINE.1 = " COPYGROUP OUTDD=OUTDD,INDD=((INDD,R))"
   Address TSO "EXECIO * DISKW SYSIN (STEM SYSLINE. FINIS)"
   Address ISPEXEC "ISPEXEC SELECT PGM(IEBCOPY)"
   Copy_rc = rc
   Address TSO "EXECIO * DISKR SYSPRINT (STEM sysinfo. FINIS)"

   x = Msg('off')
       Address TSO "FREE F(SYSIN,SYSUT4,OUTDD,INDD,SYSPRINT)"
   x = Msg('on')

   If Copy_rc <> 0 Then
   Do
      /* Display SYSTEM message from IEBCOPY in case of failure */
      Do xmit = 1 to sysinfo.0
          Say Strip(sysinfo.xmit)
      End
      call ExitProgram(Copy_rc)
   End
   /* Display output details from IEBCOPY */
   Do xmit = 1 to sysinfo.0
     parse var sysinfo.xmit sysw1 sysw2 sysw3 .
     if ( strip(sysw2) == "MEMBER" ) then
        Say "   ***   MEMBER = " left(sysw3,8) "  ***   "
   End

return /* End of Function CopyPdsMembers */

CreateDatasetIfDoesNotExist :
   Address ISPEXEC "DSINFO DATASET('"TargDSN"')"
   If (rc > 0) then do
      If (rc = 8) Then Do
         say "Dataset " TargDSN " does not exist. Allocating dataset.."
         call AllocateDataset
      End
      Else Do
         say "DSINFO failed on '"TargDSN"' Return Code : "rc
         call ExitProgram(rc)
      End
   End
return

AllocateDataset :
   Address ISPEXEC "DSINFO DATASET('"SrceDSN"')"
   If (rc > 0) then Do
      say "DSINFO failed on '"SrceDSN"' Return Code : "rc
      call ExitProgram(rc)
   End
   blksize = Strip(zdsblk)
   Address TSO "ALLOC DA('"Strip(TargDSN)"') " ,
               "LIKE('"Strip(SrceDSN)"') BLKSIZE("blksize")"
   If (rc > 0) then Do
      say "Problem allocating data set '"TargDSN"' Return Code : "rc
      call ExitProgram(rc)
   End
return

ExitProgram :
    Parse arg returnCode
    ZISPFRC = returnCode
    Address ISPEXEC "VPUT (ZISPFRC) SHARED"
Exit returnCode