/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation;

import com.ibm.team.enterprise.automation.CpDataset;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class ScriptFileGenerator {
    public static final String BIN_SH = "#!/bin/sh";
    public static final String DOUBLE_SLASHES = "//";
    public static final String SINGLE_QUOTE = "'";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String BUZTOOL_TEMP = "buztool_temp";
    public static final String SH = ".sh";
    public static final String CP_COMMAND = "cp";
    public static final String SPACE = " ";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSED_PARENTHESIS = ")";
    protected final String workDirPath;
    protected final List<CpDataset> cpDatasets;

    protected ScriptFileGenerator(String workDirPath, List<CpDataset> cpDatasets) {
        this.workDirPath = workDirPath;
        this.cpDatasets = cpDatasets;
    }

    protected String getCpCommand(String src, String dest, String option) {
        return "cp " + option + SPACE + DOUBLE_QUOTE + DOUBLE_SLASHES + SINGLE_QUOTE + src + SINGLE_QUOTE + DOUBLE_QUOTE + SPACE + SINGLE_QUOTE + dest + SINGLE_QUOTE;
    }

    protected void addCommandCheck(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.newLine();
        bufferedWriter.append("if [ $? != 0 ] ; then");
        bufferedWriter.newLine();
        bufferedWriter.append("    exit 99");
        bufferedWriter.newLine();
        bufferedWriter.append("fi");
        bufferedWriter.newLine();
    }

    protected File createTempScriptFile(File directory) throws IOException {
        File tempFile = File.createTempFile(BUZTOOL_TEMP, SH, directory);
        tempFile.deleteOnExit();
        if (!tempFile.setExecutable(true, true)) {
            throw new RuntimeException(" [Error] Failed to set execute permissions for file " + tempFile.getCanonicalPath());
        }
        return tempFile;
    }

    public abstract File generateFile() throws Exception;
}

