/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.team.enterprise.automation.common.VersionType;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.zinventory.TimeTracker;
import com.ibm.urbancode.zos.zinventory.ZInventoryDataMerger;
import com.ibm.urbancode.zos.zinventory.ZInventoryHttpService;
import com.ibm.urbancode.zos.zinventory.ZInventoryRequestGenerator;
import com.urbancode.air.plugin.command.version.rollback.RollbackPackageInputs;
import com.urbancode.air.plugin.inputs.DeployPackageInputs;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryTable {
    private static final String ENVIRONMENT = "environment";
    private static final String VERSION = "version";
    private static final String DEPLOY_TIME = "deploy-time";
    private static final String RESOURCES = "resources";
    private static final String OVERWRITE_UPDATED_FILES = "overwriteUpdatedFiles";
    private static final String VERSION_NAME_GLOB = "versionNameGlob";
    private static final String ENVIRONMENTS = "environments";
    private final String environmentId;
    private final String versionId;

    public ZInventoryTable(String versionId, String environmentId) {
        this.versionId = versionId;
        this.environmentId = environmentId;
    }

    public static void updateDeploymentData(DeployPackageInputs pluginInputs, TimeTracker timeTracker, String componentVersionWorkingDir) throws IOException, XMLStreamException, JSONException, URISyntaxException {
        ZInventoryTable zInventoryTable = new ZInventoryTable(pluginInputs.getVersionId(), pluginInputs.getEnvironmentId());
        if (pluginInputs.isLinkedVersion()) {
            zInventoryTable.updateForDeployWithLinkedVersion(pluginInputs, componentVersionWorkingDir);
        } else {
            zInventoryTable.updateForDeploy(timeTracker.getDeployTime(), componentVersionWorkingDir);
        }
    }

    public static void updateRollbackData(RollbackPackageInputs pluginInputs) throws IOException, URISyntaxException {
        ZInventoryTable zInventoryTable = new ZInventoryTable(pluginInputs.getVersionId(), pluginInputs.getEnvironmentId());
        if (pluginInputs.shouldRollbackNonRiskyArtifacts()) {
            zInventoryTable.updateForNonRiskyRollback();
        } else {
            zInventoryTable.updateForRollback();
        }
    }

    private void updateForDeployWithLinkedVersion(DeployPackageInputs pluginInputs, String componentVersionWorkingDir) throws JSONException, XMLStreamException, IOException, URISyntaxException {
        JSONObject requestBody = new JSONObject();
        requestBody.put(ENVIRONMENT, (Object)this.environmentId);
        requestBody.put(VERSION, (Object)this.versionId);
        JSONArray resources = this.getResources(componentVersionWorkingDir);
        if (resources.length() == 0) {
            Console.printProcessOutput("No artifacts found to update in Z Inventory.");
            return;
        }
        Optional<String> currentZInventoryData = this.getCurrentZInventoryData(pluginInputs, componentVersionWorkingDir);
        resources = currentZInventoryData.isPresent() ? ZInventoryDataMerger.mergeData(resources, new JSONArray(currentZInventoryData.get())) : this.getDeployedResources(resources);
        requestBody.put(RESOURCES, (Object)resources);
        ZInventoryHttpService.addDeploymentDataToZInventoryTable(requestBody.toString());
        this.storeZInventoryResourcesToFileForSuccessiveDeploySteps(resources, componentVersionWorkingDir);
    }

    private Optional<String> getCurrentZInventoryData(DeployPackageInputs pluginInputs, String componentVersionWorkingDir) throws IOException, JSONException, URISyntaxException {
        String zInventoryJsonFilePath = componentVersionWorkingDir + File.separator + "zInventory.json";
        if (FileHelper.isFileExist(zInventoryJsonFilePath)) {
            return Optional.of(FileHelper.getFileContent(zInventoryJsonFilePath));
        }
        if (pluginInputs.getFromVersionName().isEmpty()) {
            return Optional.of(this.getCurrentZInventoryDataFromServer(pluginInputs.getVersionName()));
        }
        if (pluginInputs.getFromVersionType().equalsIgnoreCase(VersionType.LINKED.name())) {
            return Optional.of(this.getCurrentZInventoryDataFromServer(pluginInputs.getFromVersionName()));
        }
        return Optional.empty();
    }

    private void updateForRollback() throws IOException, URISyntaxException {
        List<NameValuePair> params = this.getConstantRollbackParams();
        ZInventoryHttpService.rollbackDataInZInventoryTable(params);
    }

    private void updateForNonRiskyRollback() throws IOException, URISyntaxException {
        List<NameValuePair> params = this.getConstantRollbackParams();
        params.add((NameValuePair)new BasicNameValuePair(OVERWRITE_UPDATED_FILES, "false"));
        ZInventoryHttpService.rollbackDataInZInventoryTable(params);
    }

    private List<NameValuePair> getConstantRollbackParams() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair(ENVIRONMENT, this.environmentId));
        params.add((NameValuePair)new BasicNameValuePair(VERSION, this.versionId));
        return params;
    }

    private String getCurrentZInventoryDataFromServer(String versionName) throws JSONException, IOException, URISyntaxException {
        JSONObject requestBody = new JSONObject();
        JSONArray environments = new JSONArray();
        environments.put((Object)this.environmentId);
        requestBody.put(ENVIRONMENTS, (Object)environments);
        requestBody.put(VERSION_NAME_GLOB, (Object)versionName);
        return ZInventoryHttpService.searchDataInZInventoryTable(requestBody.toString());
    }

    private JSONArray getDeployedResources(JSONArray resources) throws JSONException {
        JSONArray deployedResources = new JSONArray();
        for (int i = 0; i < resources.length(); ++i) {
            JSONObject resource = resources.getJSONObject(i);
            String operationType = resource.getString("operation-type");
            if (!operationType.equals("DEPLOY")) continue;
            deployedResources.put((Object)resource);
        }
        return deployedResources;
    }

    private void storeZInventoryResourcesToFileForSuccessiveDeploySteps(JSONArray updatedResources, String componentVersionWorkingDir) throws JSONException, IOException {
        String filePath = componentVersionWorkingDir + File.separator + "zInventory.json";
        FileHelper.writeStringToFile(updatedResources.toString(4), filePath);
    }

    private void updateForDeploy(long deployTime, String componentVersionWorkingDir) throws XMLStreamException, JSONException, IOException, URISyntaxException {
        JSONObject requestBody = new JSONObject();
        requestBody.put(ENVIRONMENT, (Object)this.environmentId);
        requestBody.put(VERSION, (Object)this.versionId);
        requestBody.put(DEPLOY_TIME, deployTime);
        requestBody.put(RESOURCES, (Object)this.getResources(componentVersionWorkingDir));
        ZInventoryHttpService.addDeploymentDataToZInventoryTable(requestBody.toString());
    }

    private JSONArray getResources(String componentVersionWorkingDir) throws XMLStreamException, IOException {
        ZInventoryRequestGenerator zInventoryRequestGenerator = new ZInventoryRequestGenerator(componentVersionWorkingDir);
        return zInventoryRequestGenerator.buildRequestPayload();
    }
}

