/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.wait;

import com.urbancode.air.plugin.command.jcl.common.jes.JESJob;
import com.urbancode.air.plugin.command.jcl.common.jes.JMConnection;
import com.urbancode.air.plugin.command.jcl.wait.WaitForJobInputs;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.util.Properties;

public class WaitForJob {
    private final Properties inputProperties;
    private final Properties outputProperties;

    public WaitForJob(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            String showOutput;
            WaitForJobInputs pluginInputs = WaitForJobInputs.getValidatedInputs(this.inputProperties);
            JMConnection jmConnection = JMConnection.getInstance(pluginInputs.getJmonInputs());
            jmConnection.setJobId(pluginInputs.getJobId());
            boolean isJobSuccessfullyCompleted = jmConnection.waitForJob();
            JESJob jesJob = jmConnection.getJob();
            this.setOutputProperties(pluginInputs.getJobId(), jesJob);
            if (jesJob.isCompleted()) {
                System.out.println("Job Completed");
                jmConnection.printJobDetails();
            }
            if ((showOutput = pluginInputs.getJmonInputs().getShowOutput()).equals("ALL")) {
                jmConnection.printJobLog();
            } else {
                String[] ddList = showOutput.split(",");
                jmConnection.printOnlyGivenDDs(ddList);
            }
            jmConnection.disconnect();
            if (isJobSuccessfullyCompleted) {
                return 0;
            }
        }
        catch (InvalidInputException | MissingInputException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error Running Job: " + e.getMessage());
            e.printStackTrace();
        }
        return 1;
    }

    private void setOutputProperties(String jobId, JESJob jesJob) {
        this.outputProperties.setProperty("JobId", jobId);
        this.outputProperties.setProperty("JobReturnCode", jesJob.getReturnCode() == null ? "" : jesJob.getReturnCode());
        this.outputProperties.setProperty("JobReturnInfo", jesJob.getReturnInfo() == null ? "" : jesJob.getReturnInfo());
        this.outputProperties.setProperty("JobReturnStatus", jesJob.getReturnStatus() == null ? "" : jesJob.getReturnStatus());
    }
}

