/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DeployManifestMvsGenerator {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private static final String LAST_MODIFIED_USERID = "lastModifiedUserid";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private final PackageManifest packageManifest;
    private XMLStreamWriter xmlStreamWriter = null;

    private DeployManifestMvsGenerator(PackageManifest packageManifest) {
        this.packageManifest = packageManifest;
    }

    public static String generate(String packageManifestPath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = PackageManifest.from((String)packageManifestPath);
        DeployManifestMvsGenerator deployManifestMvsGenerator = new DeployManifestMvsGenerator(packageManifest);
        return deployManifestMvsGenerator.generateXML();
    }

    private String generateXML() throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements(this.packageManifest);
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements(PackageManifest packageManifest) throws XMLStreamException {
        this.createXmlHeaderTag();
        this.createStartingManifestTag();
        this.writeContainers(packageManifest.getAddedContainers());
        this.writeDeletedContainers(packageManifest.getDeletedContainers());
        this.writeEndingManifestTag();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeEndingManifestTag() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void createStartingManifestTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("manifest");
        if (this.packageManifest.getVersion() != null) {
            this.xmlStreamWriter.writeAttribute("version", this.packageManifest.getVersion());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void createXmlHeaderTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeDeletedContainers(List<Container> deletedContainers) throws XMLStreamException {
        if (deletedContainers.isEmpty()) {
            return;
        }
        this.writeStartingDeletedTag();
        this.writeContainers(deletedContainers);
        this.writeEndElement();
    }

    private void writeStartingDeletedTag() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("deleted");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainers(List<Container> containers) throws XMLStreamException {
        for (Container container : containers) {
            if (container.isPds()) {
                this.writePDSContainer(container);
                continue;
            }
            if (!container.isSequential()) continue;
            this.writeSequentialContainer(container);
        }
    }

    private void writePDSContainer(Container container) throws XMLStreamException {
        this.writeStartingContainerTag(container);
        this.writeContainerResources(container.getResources());
        this.writeEndElement();
    }

    private void writeSequentialContainer(Container container) throws XMLStreamException {
        this.writeStartingContainerTag(container);
        this.writeEndElement();
    }

    private void writeStartingContainerTag(Container container) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("container");
        this.xmlStreamWriter.writeAttribute("name", container.getSourceName());
        String datasetType = container.getType().toString();
        this.xmlStreamWriter.writeAttribute("type", datasetType);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainerResources(Collection<Resource> members) throws XMLStreamException {
        for (Resource member : members) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
            this.xmlStreamWriter.writeEmptyElement("resource");
            this.xmlStreamWriter.writeAttribute("name", member.getName());
            this.xmlStreamWriter.writeAttribute("type", member.getType());
            String lastModifiedTimestamp = member.getLastModifiedTimestamp();
            String lastModifiedUserid = (String)member.getCustomerProperties().get(LAST_MODIFIED_USERID);
            if (this.isNotNullOrEmpty(lastModifiedUserid) && this.isNotNullOrEmpty(lastModifiedTimestamp)) {
                if (this.isTimestampInEpochFormat(lastModifiedTimestamp)) {
                    lastModifiedTimestamp = this.convertEpochTimeToTimestamp(lastModifiedTimestamp);
                }
                this.xmlStreamWriter.writeAttribute(LAST_MODIFIED_USERID, lastModifiedUserid);
                this.xmlStreamWriter.writeAttribute("lastModifiedTimestamp", lastModifiedTimestamp);
            }
            this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        }
    }

    private boolean isTimestampInEpochFormat(String timeStamp) {
        return timeStamp.matches("^\\d{13}$");
    }

    private String convertEpochTimeToTimestamp(String lastModifiedTimestamp) {
        return DeployManifestMvsGenerator.convertEpochTimeToTimestamp(lastModifiedTimestamp, TimeZone.getDefault());
    }

    static String convertEpochTimeToTimestamp(String lastModifiedTimestamp, TimeZone timeZone) {
        long epochTime = Long.parseLong(lastModifiedTimestamp);
        Date date = new Date(epochTime);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        sdf.setTimeZone(timeZone);
        return sdf.format(date);
    }

    private boolean isNotNullOrEmpty(String value) {
        return value != null && !value.trim().isEmpty();
    }
}

