/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.team.enterprise.automation.common.VersionType;
import com.ibm.team.enterprise.deployment.hfs.BackupFilesTask;
import com.ibm.team.enterprise.deployment.hfs.DeployFilesTask;
import com.ibm.team.enterprise.deployment.toolkit.manifest.MvsBackupTaker;
import com.ibm.team.enterprise.deployment.toolkit.manifest.MvsV2BackupTaker;
import com.ibm.urbancode.groovy.xml.utils.DatasetContainerRemover;
import com.ibm.urbancode.groovy.xml.utils.MergedVersion;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.urbancode.air.plugin.command.version.common.PackageManifestHelper;
import com.urbancode.air.plugin.command.version.common.TarUtil;
import com.urbancode.air.plugin.command.version.deployment.NewPackageFormatDeployer;
import com.urbancode.air.plugin.command.version.deployment.OldPackageFormatDeployer;
import com.urbancode.air.plugin.command.version.deployment.PDSChecker;
import com.urbancode.air.plugin.inputs.DeployPackageInputs;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.ResourceClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONObject;

public class DeploymentHelper {
    private static final int BUFFER_SIZE = 2048;
    private final String tempDsnPrefix;
    private final String resourceId;
    private final String componentId;
    private final String versionName;
    private final String versionType;
    private final boolean isBackupEnabled;
    private final boolean isMergedVersion;
    private final boolean oldVersionIdentifier;
    private final boolean deleteCurrentContents;
    private final boolean isTraceOn;
    private final String componentVersionWorkingDir;
    private final boolean isReplacePdsMemberDisabled;
    private final String ispfGatewayBinPath;
    private final String manifestDeployFilePath;
    private final String containerMapperFilePath;
    private final DeployedVersion deployedVersion;
    private final boolean isIncrementalModeFull;
    private final boolean isLinkedVersion;
    private MergedVersion mergedVersion;
    private boolean isVersionSameAsLastVersionInEnvironment = false;

    public DeploymentHelper(DeployPackageInputs pluginInputs) throws IOException {
        this.tempDsnPrefix = pluginInputs.getTempDsnPrefix();
        this.resourceId = pluginInputs.getResourceId();
        this.componentId = pluginInputs.getComponentId();
        this.versionName = pluginInputs.getVersionName();
        this.versionType = pluginInputs.getVersionType();
        this.isBackupEnabled = pluginInputs.isBackupEnabled();
        this.isMergedVersion = pluginInputs.isMergedVersion();
        this.oldVersionIdentifier = pluginInputs.isOldHfsMappingFormat();
        this.deleteCurrentContents = pluginInputs.isDeleteCurrentContentsEnabled();
        this.isTraceOn = pluginInputs.isPrintLogsEnabled();
        this.isReplacePdsMemberDisabled = pluginInputs.isReplacePdsMemberDisabled();
        this.componentVersionWorkingDir = DeploymentFilesHelper.getVersionDirPathInWorkingDir(this.versionName, this.resourceId);
        this.ispfGatewayBinPath = pluginInputs.getIspfGatewayBinPath();
        this.manifestDeployFilePath = this.componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        this.containerMapperFilePath = this.componentVersionWorkingDir + File.separator + "containerMapper.xml";
        this.deployedVersion = pluginInputs.getDeployedVersion();
        this.isIncrementalModeFull = pluginInputs.incrementalModeIsFull();
        this.isLinkedVersion = pluginInputs.isLinkedVersion();
    }

    public void performDeployment(Set<String> containersDSListToRemove, boolean isFirstTimePartialDeploy) throws Exception {
        if (isFirstTimePartialDeploy) {
            this.createBackup();
        }
        if (!containersDSListToRemove.isEmpty()) {
            DatasetContainerRemover.remove((String)this.manifestDeployFilePath, containersDSListToRemove);
        }
        if (!isFirstTimePartialDeploy) {
            DatasetContainerRemover.removeHfsContainers((String)this.manifestDeployFilePath);
        }
        this.deploy(isFirstTimePartialDeploy);
        if (isFirstTimePartialDeploy) {
            this.postDeploy();
        }
    }

    private void createBackup() throws Exception {
        Console.printActionTitle("Backup:");
        this.isVersionSameAsLastVersionInEnvironment = this.isVersionSameAsLastDeployedVersion();
        if (this.isVersionSameAsLastVersionInEnvironment) {
            Console.printProcessOutput("Backup is skipped since the current version is same as the last deployed version in the environment.");
            return;
        }
        boolean skipBackup = false;
        if (!this.isBackupEnabled || this.isVersionFullOrLinked()) {
            Console.printProcessOutput("Backup is skipped. ");
            skipBackup = true;
        }
        PackageManifest packageManifestDeployXml = PackageManifest.from((String)this.manifestDeployFilePath);
        if (skipBackup) {
            this.generateDeltaDeployedXml(packageManifestDeployXml);
        } else {
            this.performBackup(packageManifestDeployXml);
        }
        this.createVersionDeployBaseDirectory();
        this.copyFileToVersionDeployDirectory("backup.zip");
        this.copyDeltaDeployedXmlAsRollbackManifestXmlToDeployDirectory();
        System.out.println();
    }

    private boolean isVersionFullOrLinked() {
        return this.versionType.equalsIgnoreCase(VersionType.FULL.name()) || this.isLinkedVersion;
    }

    private void generateDeltaDeployedXml(PackageManifest packageManifestDeployXml) throws Exception {
        if (packageManifestDeployXml.hasDataset()) {
            this.createMvsDeltaDeployedXml(packageManifestDeployXml);
        }
        if (packageManifestDeployXml.hasHFSFile()) {
            BackupFilesTask.generateDeltaDeployedXmlFile(this.oldVersionIdentifier, this.componentVersionWorkingDir);
        }
    }

    private void performBackup(PackageManifest packageManifestDeployXml) throws Exception {
        if (packageManifestDeployXml.hasDataset()) {
            this.takeMVSBackup(packageManifestDeployXml);
        }
        if (packageManifestDeployXml.hasHFSFile()) {
            BackupFilesTask.executeTask(this.oldVersionIdentifier, this.componentVersionWorkingDir);
        }
    }

    private void createMvsDeltaDeployedXml(PackageManifest packageManifestDeployXml) throws Exception {
        if (packageManifestDeployXml.isLinkedVersion() || packageManifestDeployXml.isNewPackageFormat() && this.allContainersHaveCopyType(packageManifestDeployXml)) {
            MvsV2BackupTaker.generateDeltaDeployedXmlFile(this.componentVersionWorkingDir);
        } else {
            MvsBackupTaker mvsBackupTaker = new MvsBackupTaker(this.isTraceOn, this.tempDsnPrefix, this.ispfGatewayBinPath);
            mvsBackupTaker.generateDeltaDeployedXmlFile(this.componentVersionWorkingDir);
        }
    }

    private void takeMVSBackup(PackageManifest packageManifestDeployXml) throws Exception {
        if (packageManifestDeployXml.isNewPackageFormat() && this.allContainersHaveCopyType(packageManifestDeployXml)) {
            MvsV2BackupTaker.takeBackup(this.componentVersionWorkingDir);
        } else {
            MvsBackupTaker mvsBackupTaker = new MvsBackupTaker(this.isTraceOn, this.tempDsnPrefix, this.ispfGatewayBinPath);
            mvsBackupTaker.takeBackup(this.componentVersionWorkingDir);
        }
    }

    private boolean allContainersHaveCopyType(PackageManifest packageManifestDeployXml) {
        return packageManifestDeployXml.getContainers().stream().noneMatch(container -> container.getCopyType() == null);
    }

    private void deploy(boolean isFirstTimePartialDeploy) throws Exception {
        Console.printActionTitle("Deploy:");
        System.out.println();
        String packageZipFilePath = this.componentVersionWorkingDir + File.separator + "package.zip";
        PackageManifest manifestDeployXml = PackageManifest.from((String)this.manifestDeployFilePath);
        if (manifestDeployXml.hasDataset()) {
            this.deployDatasets(manifestDeployXml, packageZipFilePath);
        }
        if (isFirstTimePartialDeploy && manifestDeployXml.hasHFSFile()) {
            this.deployHFSFiles(packageZipFilePath);
        }
    }

    private void deployDatasets(PackageManifest manifestDeployXml, String packageZipFilePath) throws Exception {
        if (this.isReplacePdsMemberDisabled) {
            this.checkForAnyExistingPdsMembers();
        }
        Console.printActionTitle("Deploy data sets:");
        if (manifestDeployXml.isNewPackageFormat() || this.isLinkedVersion) {
            NewPackageFormatDeployer newPackageFormatDeployer = new NewPackageFormatDeployer(this.isTraceOn, this.tempDsnPrefix, this.componentVersionWorkingDir);
            newPackageFormatDeployer.deploy(this.ispfGatewayBinPath);
        } else {
            OldPackageFormatDeployer oldPackageFormatDeployer = new OldPackageFormatDeployer(this.isTraceOn, this.tempDsnPrefix, this.ispfGatewayBinPath);
            if (this.isMergedVersion) {
                this.deployMergedDatasetPackagesInOldFormat(packageZipFilePath, oldPackageFormatDeployer);
            } else {
                oldPackageFormatDeployer.deploy(this.manifestDeployFilePath, this.containerMapperFilePath, this.componentVersionWorkingDir);
            }
        }
    }

    private void deployMergedDatasetPackagesInOldFormat(String packageZipFilePath, OldPackageFormatDeployer oldPackageFormatDeployer) throws Exception {
        try (ZipFile zipFile = new ZipFile(packageZipFilePath);){
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            while (zipFileEntries.hasMoreElements()) {
                PackageManifest innerManifestXml;
                ZipEntry zipEntry = zipFileEntries.nextElement();
                if (!zipEntry.getName().matches("packageManifest_.+\\.xml")) continue;
                String versionId = this.getVersionId(zipEntry.getName());
                String innerComponentVersionWorkingDir = this.componentVersionWorkingDir + File.separator + versionId;
                FileHelper.createDirectory(innerComponentVersionWorkingDir);
                Console.printProcessOutput("Deploying data sets from original version : " + versionId);
                String innerPackageZipPath = innerComponentVersionWorkingDir + File.separator + "package.zip";
                ZipEntry packageZipEntry = zipFile.getEntry("package_" + versionId + ".zip");
                if (packageZipEntry != null) {
                    this.extractFileFromZip(zipFile, packageZipEntry, innerPackageZipPath);
                }
                ZipEntry packageManifestEntry = zipFile.getEntry("packageManifest_" + versionId + ".xml");
                String innerManifestFilePath = innerComponentVersionWorkingDir + File.separator + "packageManifest.xml";
                this.extractFileFromZip(zipFile, packageManifestEntry, innerManifestFilePath);
                if (!this.isIncrementalModeFull) {
                    this.compareWithParentAndKeepDeltasOnlyInChild(this.manifestDeployFilePath, innerManifestFilePath);
                }
                if ((innerManifestXml = PackageManifest.from((String)innerManifestFilePath)).hasDataset()) {
                    oldPackageFormatDeployer.deploy(innerManifestFilePath, this.containerMapperFilePath, innerComponentVersionWorkingDir);
                    continue;
                }
                Console.printProcessOutput("Nothing to deploy from original version : " + versionId);
            }
        }
    }

    private void compareWithParentAndKeepDeltasOnlyInChild(String parentManifestFilePath, String childManifestFilePath) {
        if (this.mergedVersion == null) {
            this.mergedVersion = new MergedVersion(parentManifestFilePath);
        }
        this.mergedVersion.applyDelta(childManifestFilePath);
    }

    private String getVersionId(String packageManifestName) {
        int endPos = packageManifestName.indexOf(".xml");
        int startPos = "packageManifest_".length();
        return packageManifestName.substring(startPos, endPos);
    }

    private void extractFileFromZip(ZipFile zipFile, ZipEntry zipEntry, String outputFilePath) throws IOException {
        try (InputStream input = zipFile.getInputStream(zipEntry);
             BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(Paths.get(outputFilePath, new String[0]), new OpenOption[0]));){
            int currentByte;
            byte[] data = new byte[2048];
            while ((currentByte = input.read(data, 0, 2048)) != -1) {
                output.write(data, 0, currentByte);
            }
        }
    }

    private void deployHFSFiles(String packageZipFilePath) throws Exception {
        String artifactsDir;
        Console.printActionTitle("Deploy HFS files:");
        String containerMapperHFSFilePath = this.componentVersionWorkingDir + File.separator + "containerMapperHFS.xml";
        if (this.isLinkedVersion) {
            artifactsDir = this.componentVersionWorkingDir + File.separator + "HFS";
        } else {
            String unpackDir = this.componentVersionWorkingDir + File.separator + "unpacked";
            FileHelper.emptyDirectory(unpackDir);
            this.extractZipFile(unpackDir, packageZipFilePath);
            artifactsDir = unpackDir + File.separator + "HFS";
        }
        DeployFilesTask deployFilesTask = new DeployFilesTask(artifactsDir, this.oldVersionIdentifier);
        deployFilesTask.execute(this.manifestDeployFilePath, containerMapperHFSFilePath, this.deleteCurrentContents);
        System.out.println();
    }

    private void extractZipFile(String unpackDir, String packageZipFilePath) throws IOException {
        String processedPackageZipFilePath = this.componentVersionWorkingDir + File.separator + "processed_package.zip";
        if (FileHelper.isFileExist(processedPackageZipFilePath)) {
            TarUtil.untar(unpackDir, processedPackageZipFilePath);
        } else if (FileHelper.isFileExist(packageZipFilePath)) {
            TarUtil.untar(unpackDir, packageZipFilePath);
        }
    }

    private void checkForAnyExistingPdsMembers() throws XMLStreamException, IOException {
        Console.printActionTitle("Checking for target PDS members:");
        System.out.println();
        List<String> existingPDSMembers = PDSChecker.getListOfExistingPdsMembers(this.manifestDeployFilePath, this.containerMapperFilePath);
        if (!existingPDSMembers.isEmpty()) {
            Console.printProcessOutput("Exiting with non-zero return code as following PDS members already exist and input 'Replace PDS member' is set to 'FALSE'");
            System.out.println();
            for (String pdsMember : existingPDSMembers) {
                Console.printProcessOutput(pdsMember);
            }
            System.exit(8);
        }
        Console.printProcessOutput("No existing PDS members found on target datasets.");
    }

    public void postDeploy() throws IOException {
        Console.printActionTitle("PostDeploy:");
        if (this.isVersionSameAsLastVersionInEnvironment) {
            this.printRollbackXml();
        } else {
            this.printDeltaDeployedXml();
        }
        this.storeDeploymentFiles();
    }

    private void storeDeploymentFiles() throws IOException {
        this.createVersionDeployBaseDirectory();
        System.out.println();
        Console.printActionTitle("Store deploy results:");
        this.copyFilesToVersionDeployBasePath();
        System.out.println();
    }

    private void copyFilesToVersionDeployBasePath() throws IOException {
        this.copyFileToVersionDeployDirectory("packageManifest.xml");
        this.copyFileToVersionDeployDirectory("containerMapper.xml");
        this.copyFileToVersionDeployDirectory("dataSetListFile");
        this.copyFileToVersionDeployDirectory("backupDatasetProperties.xml");
        this.copyFileToVersionDeployDirectory("containerMapperHFS.xml");
        if (!this.oldVersionIdentifier) {
            this.copyFileToVersionDeployDirectory("tempFileNewVersion.xml");
        }
    }

    private void printDeltaDeployedXml() throws IOException {
        String deltaDeployedFilePath = this.componentVersionWorkingDir + File.separator + "deltaDeployed.xml";
        if (FileHelper.isFileExist(deltaDeployedFilePath)) {
            Console.printActionTitle("Deploy Report:");
            Console.printProcessOutput(FileHelper.getFileContent(deltaDeployedFilePath));
        }
    }

    private void printRollbackXml() throws IOException {
        String rollbackManifestFilePath = this.deployedVersion.getVersionDirPath() + File.separator + "rollbackManifest.xml";
        if (FileHelper.isFileExist(rollbackManifestFilePath)) {
            Console.printActionTitle("Deploy Report:");
            Console.printProcessOutput(FileHelper.getFileContent(rollbackManifestFilePath));
        }
    }

    public void postDeployForGenericOnly() throws IOException {
        Console.printActionTitle("PostDeploy:");
        this.createVersionDeployBaseDirectory();
        this.copyFileToVersionDeployDirectory("packageManifest.xml");
        System.out.println();
    }

    private void copyFileToVersionDeployDirectory(String fileName) throws IOException {
        String src = this.componentVersionWorkingDir + File.separator + fileName;
        String target = this.deployedVersion.getVersionDirPath() + File.separator + fileName;
        if (FileHelper.isFileExist(src)) {
            FileHelper.copyFile(src, target);
        }
    }

    private void copyDeltaDeployedXmlAsRollbackManifestXmlToDeployDirectory() throws IOException {
        String src = this.componentVersionWorkingDir + File.separator + "deltaDeployed.xml";
        String target = this.deployedVersion.getVersionDirPath() + File.separator + "rollbackManifest.xml";
        if (FileHelper.isFileExist(src)) {
            FileHelper.copyFile(src, target);
        }
    }

    public int printPartialDeployedDatasets() throws IOException, XMLStreamException {
        Console.printActionTitle("Partial Deployment Summary: ");
        Set<String> processedDatasets = this.getProcessedDatasets();
        Console.printActionTitle("\n\tDatasets processed (Total - " + processedDatasets.size() + "): \n");
        for (String dsName : processedDatasets) {
            System.out.println("\t\t" + dsName);
        }
        Set<String> packageDatasets = this.getPackageDatasets();
        packageDatasets.removeAll(processedDatasets);
        Console.printActionTitle("\n\tDatasets remaining (Total - " + packageDatasets.size() + "): \n");
        for (String dsName : packageDatasets) {
            System.out.println("\t\t" + dsName);
        }
        return packageDatasets.size();
    }

    private Set<String> getProcessedDatasets() throws IOException {
        String trackerFilePath = this.componentVersionWorkingDir + File.separator + "deployContainerTracker.txt";
        HashSet<String> datasets = new HashSet<String>();
        if (FileHelper.isFileExist(trackerFilePath)) {
            datasets.addAll(FileHelper.getLines(trackerFilePath));
        }
        return datasets;
    }

    private Set<String> getPackageDatasets() throws XMLStreamException, IOException {
        String deployManifestFilePath = this.componentVersionWorkingDir + File.separator + "packageManifest_backup_deploy.xml";
        PackageManifest packageManifestDeploy = PackageManifest.from((String)deployManifestFilePath);
        return PackageManifestHelper.getDatasets(packageManifestDeploy);
    }

    private boolean isVersionSameAsLastDeployedVersion() {
        if (this.deployedVersion.hasBackup()) {
            Console.printActionTitle("Check last deployed version:");
            try {
                String latestVersionName;
                ResourceClient resourceClient = UdClientHelper.getResourceClient();
                XTrustProvider.install();
                JSONObject latestVersionJson = resourceClient.getLatestVersionByResourceAndComponent(this.resourceId, this.componentId);
                if (null != latestVersionJson && latestVersionJson.has("version") && null != (latestVersionJson = latestVersionJson.getJSONObject("version")) && latestVersionJson.has("name") && (latestVersionName = latestVersionJson.getString("name")) != null && latestVersionName.trim().equals(this.versionName)) {
                    Console.printProcessOutput("A backup is already taken by the previous deploy.");
                    Console.printProcessOutput("");
                    return true;
                }
            }
            catch (Exception e) {
                Console.printProcessOutput("Warning: check last deployed version failed.");
            }
        }
        return false;
    }

    private void createVersionDeployBaseDirectory() {
        if (FileHelper.isDirectoryNotExist(this.deployedVersion.getVersionDirPath())) {
            FileHelper.createDirectory(this.deployedVersion.getVersionDirPath());
        }
    }
}

