/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.mappings;

import com.ibm.urbancode.zos.common.util.StringHelper;
import com.urbancode.air.plugin.command.version.mappings.InvalidMappingException;
import com.urbancode.air.plugin.command.version.mappings.MappingHelper;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatasetMapper {
    private final Map<String, Set<String>> srcTargetMapWithRegEx = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> srcTargetMapWithoutRegEx = new LinkedHashMap<String, Set<String>>();
    private final String datasetMapping;

    private DatasetMapper(String datasetMapping) {
        this.datasetMapping = datasetMapping;
    }

    public static DatasetMapper from(String datasetMapping) {
        DatasetMapper deployDatasetMapper = new DatasetMapper(datasetMapping);
        deployDatasetMapper.loadMappingIntoMaps();
        return deployDatasetMapper;
    }

    private void loadMappingIntoMaps() {
        List<String> mappingPairs = StringHelper.getLines(this.datasetMapping);
        for (String mappingPair : mappingPairs) {
            if ((mappingPair = mappingPair.trim()).isEmpty()) continue;
            this.loadPairIntoMap(mappingPair);
        }
    }

    private void loadPairIntoMap(String mappingPair) {
        String[] onePair = mappingPair.split(",");
        if (onePair.length != 2) {
            throw new InvalidMappingException("Dataset Mapping is incorrect - " + mappingPair);
        }
        String source = onePair[0].trim();
        String target = onePair[1].trim();
        if (source.isEmpty()) {
            throw new InvalidMappingException("Missing source dataset in Dataset Mapping - " + mappingPair);
        }
        if (MappingHelper.containsWildcardCharacter(source)) {
            this.loadMappingIntoMapWithWildcard(source, target);
        } else {
            this.loadMappingIntoMapWithoutWildcard(source, target);
        }
    }

    private void loadMappingIntoMapWithoutWildcard(String source, String target) {
        if (this.srcTargetMapWithoutRegEx.containsKey(source)) {
            this.srcTargetMapWithoutRegEx.get(source).add(target);
        } else {
            this.srcTargetMapWithoutRegEx.put(source, this.getNewSetWith(target));
        }
    }

    private void loadMappingIntoMapWithWildcard(String source, String target) {
        String sourceWithRegularExp = MappingHelper.convertWildcardsToRegularExp(source);
        if (this.srcTargetMapWithRegEx.containsKey(sourceWithRegularExp)) {
            this.srcTargetMapWithRegEx.get(sourceWithRegularExp).add(target);
        } else {
            this.srcTargetMapWithRegEx.put(sourceWithRegularExp, this.getNewSetWith(target));
        }
    }

    private Set<String> getNewSetWith(String target) {
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        targets.add(target);
        return targets;
    }

    public Map<String, Set<String>> getSrcTargetMapWithRegEx() {
        return this.srcTargetMapWithRegEx;
    }

    public Map<String, Set<String>> getSrcTargetMapWithoutRegEx() {
        return this.srcTargetMapWithoutRegEx;
    }
}

