/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.binder.jni;

import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.ZFile;
import com.ibm.teamz.build.binder.jni.BinderException;
import com.ibm.teamz.build.binder.jni.BinderInfo;
import com.ibm.teamz.build.binder.jni.FileUtil;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BinderInfoZTests {
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String TEMP_C_FILE_PATH_0 = "./tempc0.log";
    private static final String TEMP_C_FILE_PATH_1 = "./tempc1.log";
    private static final String TEMP_C_FILE_PATH_2 = "./tempc2.log";
    private static final String TEMP_C_FILE_PATH_3 = "./tempc3.log";
    private static final String TEMP_C_FILE_PATH_4 = "./tempc4.log";

    @BeforeClass
    public static void setUpJavaLibPath() {
        System.setProperty(JAVA_LIBRARY_PATH, "dist" + File.pathSeparator + System.getProperty(JAVA_LIBRARY_PATH));
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowEmptyPds() {
        String targetPDS = "";
        String memberName = "UNKNOWN";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_0);
        BinderInfo.from(targetPDS, memberName, filePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowPds_withMoreThan44Characters() {
        String targetPDS = "ABCDEFGH.IJKLMNOP.QRSTUVWX.YZ.ABCDEFGH.IJKLMN";
        String memberName = "UNKNOWN";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_0);
        BinderInfo.from(targetPDS, memberName, filePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowEmptyMember() {
        String targetPDS = "ABC.XYZ";
        String memberName = "";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_0);
        BinderInfo.from(targetPDS, memberName, filePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowMember_withMoreThan8Characters() {
        String targetPDS = "ABC.XYZ";
        String memberName = "ABCDEFGHI";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_0);
        BinderInfo.from(targetPDS, memberName, filePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowEmptyFilePath() {
        String targetPDS = "ABC.XYZ";
        String memberName = "UNKNOWN";
        BinderInfo.from(targetPDS, memberName, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowFilePath_withMoreThan4096Characters() {
        String targetPDS = "ABC.XYZ";
        String memberName = "UNKNOWN";
        String filePath = FileUtil.getPathWithMoreThan4096Characters();
        BinderInfo.from(targetPDS, memberName, filePath);
    }

    @Test
    public void getLoadModuleTimeStampAndSize_shouldFail_whenMemberDoesNotExist() {
        String targetPDS = "UCD.BINDER.API.TEST.LOAD";
        String memberName = "UNKNOWN";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_1);
        try {
            BinderInfo.from(targetPDS, memberName, filePath);
            Assert.fail((String)"Expected Binder exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BinderException));
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("rc=8, rs=<0X83000514>"));
        }
    }

    @Test
    public void givenAPdsAndMember_getLoadModuleTimeStampAndSize() {
        String targetPDS = "UCD.BINDER.API.TEST.LOAD";
        String memberName = "SAMPLCBL";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_2);
        BinderInfo binderInfo = BinderInfo.from(targetPDS, memberName, filePath);
        System.out.println("Binder Output for " + targetPDS + "(" + memberName + ") is " + binderInfo.getModuleBound() + "/" + binderInfo.getModuleSize());
        Assert.assertEquals((Object)"2021047061656", (Object)binderInfo.getModuleBound());
        Assert.assertEquals((Object)"5568", (Object)binderInfo.getModuleSize());
        memberName = "CARPBACH";
        binderInfo = BinderInfo.from(targetPDS, memberName, filePath);
        System.out.println("Binder Output for " + targetPDS + "(" + memberName + ") is " + binderInfo.getModuleBound() + "/" + binderInfo.getModuleSize());
        Assert.assertEquals((Object)"2020210091655", (Object)binderInfo.getModuleBound());
        Assert.assertEquals((Object)"6928", (Object)binderInfo.getModuleSize());
    }

    @Test
    public void getLoadModuleTimeStampAndSize_shouldFail_whenPdsDoesNotExist() {
        String targetPDS = "UCD.BINDER.API.TEST.UNKNOWN";
        String memberName = "SAMPLCBL";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_3);
        try {
            BinderInfo.from(targetPDS, memberName, filePath);
            Assert.fail((String)"Expected Binder exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BinderException));
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Error code 5896, info code 2"));
        }
    }

    @Test
    public void testBinderProgramForPdsWithManyMembers() throws IOException {
        String dataset = "UCD.BINDER.API.TEST.DB2.VC10.SDSNLOAD";
        String filePath = FileUtil.getFilePath(TEMP_C_FILE_PATH_4);
        String slashSlashQuotedDsn = ZFile.getSlashSlashQuotedDSN((String)dataset, (boolean)true);
        if (!ZFile.dsExists((String)slashSlashQuotedDsn)) {
            Assert.fail((String)("PDS " + dataset + " does not exist."));
        }
        PdsDirectory pdsDirectory = new PdsDirectory(slashSlashQuotedDsn);
        for (PdsDirectory.MemberInfo memberInfo : pdsDirectory) {
            String member = memberInfo.getName();
            BinderInfo binderInfo = BinderInfo.from(dataset, member, filePath);
            System.out.println("Binder Output for " + dataset + "(" + member + ") is " + binderInfo.getModuleBound() + "/" + binderInfo.getModuleSize());
        }
    }
}

