/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.ispf.gateway.common;

import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayException;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IspfGatewayExecutor {
    private static final String CGI_CEATSO = "CGI_CEATSO";
    private static final String CGI_ISPPREF = "CGI_ISPPREF";
    private static final String LEGACY_ISPF_GATEWAY = "FALSE";
    private static final String ISPZXML = "ISPZXML";
    private static final String XML_VERSION = "<?xml version";
    private static final String PATH = "PATH";
    private final String ispzxmlFilePath;
    private final Map<String, String> environmentVars = new HashMap<String, String>();

    public IspfGatewayExecutor(String ispfGatewayPath, String dsnPrefix) {
        this.ispzxmlFilePath = ispfGatewayPath + File.separator + ISPZXML;
        this.environmentVars.put(CGI_ISPPREF, dsnPrefix);
        this.environmentVars.put(CGI_CEATSO, LEGACY_ISPF_GATEWAY);
        Map<String, String> systemEnvVars = System.getenv();
        if (systemEnvVars.containsKey(PATH)) {
            this.environmentVars.put(PATH, systemEnvVars.get(PATH) + File.pathSeparator + ispfGatewayPath);
        } else {
            this.environmentVars.put(PATH, ispfGatewayPath);
        }
    }

    public void prependDirectoryToPATH(String path) {
        this.environmentVars.put(PATH, path + File.pathSeparator + this.environmentVars.get(PATH));
    }

    void setEnvironmentVar(String key, String value) {
        this.environmentVars.put(key, value);
    }

    public IspfGatewayXMLResponse execute(IspfGatewayXMLInput ispfGatewayXMLInput) throws IOException, InterruptedException, ParserConfigurationException, SAXException {
        this.validateIspzxmlFile();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.ispzxmlFilePath);
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.environment().putAll(this.environmentVars);
        Process process = processBuilder.start();
        this.passInputToIspzxml(ispfGatewayXMLInput, process);
        StringBuilder processResponse = this.readProcessOutputBuffer(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            System.out.println("===============================");
            System.out.println("STDOUT:- ");
            System.out.println(processResponse);
            this.printFromErrorStream(process);
            throw new RuntimeException(" [Error] ISPF Gateway Executor Process failed with code " + exitCode);
        }
        String outputXml = this.getOutputXml(processResponse.toString());
        return this.getIspfGatewayXmlResponse(outputXml);
    }

    private void passInputToIspzxml(IspfGatewayXMLInput ispfGatewayXMLInput, Process process) {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));){
            printWriter.print(ispfGatewayXMLInput.getIspfInputXml());
        }
    }

    private StringBuilder readProcessOutputBuffer(Process process) throws IOException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String responseLine;
            while ((responseLine = reader.readLine()) != null) {
                if (!this.isNotConnectionProtocol(responseLine)) continue;
                response.append(responseLine).append(System.lineSeparator());
            }
            StringBuilder stringBuilder = response;
            return stringBuilder;
        }
    }

    private void validateIspzxmlFile() {
        File ispzxmlFile = new File(this.ispzxmlFilePath);
        if (!ispzxmlFile.isFile()) {
            throw new RuntimeException(" [Error] " + this.ispzxmlFilePath + " file does not exist.");
        }
        if (!ispzxmlFile.canExecute() || !ispzxmlFile.canRead()) {
            throw new RuntimeException(" [Error] " + this.ispzxmlFilePath + " file does not have Execute and Read permission.");
        }
    }

    private void printFromErrorStream(Process process) throws IOException {
        System.out.println("===============================");
        System.out.println("STDERR:- ");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String outputLine;
            while ((outputLine = reader.readLine()) != null) {
                System.out.println(outputLine);
            }
        }
    }

    private String getOutputXml(String processResponse) {
        if (processResponse.contains(XML_VERSION)) {
            int xmlTagPosition = processResponse.indexOf(XML_VERSION);
            return processResponse.substring(xmlTagPosition);
        }
        throw new IspfGatewayException(processResponse + "\nFailed to get response XML from ISPF Gateway.");
    }

    private boolean isNotConnectionProtocol(String line) {
        return !line.trim().startsWith("Connection Protocol");
    }

    private IspfGatewayXMLResponse getIspfGatewayXmlResponse(String outputXml) throws ParserConfigurationException, SAXException, IOException {
        IspfGatewayXMLResponse xmlHandler = new IspfGatewayXMLResponse();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(new InputSource(new StringReader(outputXml)), (DefaultHandler)xmlHandler);
        return xmlHandler;
    }
}

