/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.allocate.sms;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.alloc.AllocSmsCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.command.allocate.sms.AllocateDatasetSmsInputs;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.util.Properties;

public class AllocateDatasetSms {
    public static final String OUTPUT_PROPERTY_DATASET_NAME = "DatasetName";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public AllocateDatasetSms(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws ZFileException {
        try {
            AllocateDatasetSmsInputs pluginInputs = AllocateDatasetSmsInputs.getValidatedInputs(this.inputProperties);
            if (pluginInputs.isDeleteDatasetEnabled()) {
                DatasetHelper.deleteDataset(pluginInputs.getDatasetName());
            }
            DatasetAllocator allocator = this.getAllocator(pluginInputs);
            String allocatedDataset = allocator.allocate();
            System.out.println(" [INFO] Dataset " + allocatedDataset + " is created.");
            this.outputProperties.put(OUTPUT_PROPERTY_DATASET_NAME, allocatedDataset);
            return 0;
        }
        catch (InvalidInputException | MissingInputException e) {
            System.out.println(" [Error] " + e.getMessage());
            return 1;
        }
    }

    private DatasetAllocator getAllocator(AllocateDatasetSmsInputs pluginInputs) {
        return new AllocSmsCommandBuilder(pluginInputs.getDatasetName()).withManagementClass(pluginInputs.getManagementClass()).withStorageClass(pluginInputs.getStorageClass()).withDataClass(pluginInputs.getDataClass()).build();
    }
}

