/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.mvs.command;

import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

class MvsCommandInputs {
    public static final String MVS_COMMAND = "mvsCommand";
    public static final String STOP_ON_FAIL = "stopOnFail";
    public static final String FAIL_MESSAGE = "failMessage";
    public static final String SDSF_JAR_FILE = "sdsfJarFile";
    private static final int MAX_ALLOWED_LENGTH_FOR_MVS_CMD = 126;
    private final String mvsCommandLines;
    private final boolean isStopOnFail;
    private final String failMessages;
    private final String sdsfJarFilePath;
    private final List<String> mvsCommands = new ArrayList<String>();

    private MvsCommandInputs(Properties inputProperties) {
        this.mvsCommandLines = inputProperties.getProperty(MVS_COMMAND).trim();
        this.isStopOnFail = Boolean.parseBoolean(inputProperties.getProperty(STOP_ON_FAIL));
        this.failMessages = inputProperties.getProperty(FAIL_MESSAGE).trim();
        this.sdsfJarFilePath = inputProperties.getProperty(SDSF_JAR_FILE).trim();
    }

    public static MvsCommandInputs getValidatedInputs(Properties inputProperties) {
        MvsCommandInputs mvsCommandInputs = new MvsCommandInputs(inputProperties);
        mvsCommandInputs.validate();
        mvsCommandInputs.convertMvsCommandLinesToList();
        return mvsCommandInputs;
    }

    private void convertMvsCommandLinesToList() {
        try (StringReader stringReader = new StringReader(this.mvsCommandLines);
             BufferedReader bufferedReader = new BufferedReader(stringReader);){
            String mvsCommandLine;
            while ((mvsCommandLine = bufferedReader.readLine()) != null) {
                if ((mvsCommandLine = mvsCommandLine.trim()).length() > 126) {
                    throw new InvalidInputException("MVS Command " + mvsCommandLine + " exceeds limit of " + 126 + " characters.");
                }
                if (mvsCommandLine.isEmpty()) continue;
                this.mvsCommands.add(mvsCommandLine);
            }
        }
        catch (IOException e) {
            throw new InvalidInputException("Failed to read MVS Command Lines");
        }
    }

    private void validate() {
        InputsValidator.checkIfEmpty(this.mvsCommandLines, "MVS Commands");
        InputsValidator.checkIfEmpty(this.sdsfJarFilePath, "SDSF Jar File Path");
        this.validateSDSFJarFile();
    }

    private void validateSDSFJarFile() {
        File sdsfJarFile = new File(this.sdsfJarFilePath);
        if (!sdsfJarFile.isFile()) {
            throw new InvalidInputException("SDSF Jar File " + this.sdsfJarFilePath + " does not exist.");
        }
        if (!sdsfJarFile.canRead()) {
            throw new InvalidInputException("SDSF Jar File " + this.sdsfJarFilePath + " is not readable.");
        }
    }

    public List<String> getMvsCommands() {
        return this.mvsCommands;
    }

    public boolean isStopOnFail() {
        return this.isStopOnFail;
    }

    public String getFailMessages() {
        return this.failMessages;
    }
}

