/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.v2;

import com.ibm.team.enterprise.automation.v2.CpDataset;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public final class CpScriptExecutor {
    private static final String IBM_1047 = "IBM-1047";
    private static final String BIN_SH = "#!/bin/sh";
    private static final String DOUBLE_SLASHES = "//";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String BUZTOOL_TEMP = "buztool_temp";
    private static final String SH = ".sh";
    private static final String CP_COMMAND = "cp";
    private static final String SPACE = " ";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSED_PARENTHESIS = ")";
    private final String workDirPath;
    private final List<CpDataset> cpDatasets;
    private final String zipName;

    private CpScriptExecutor(String workDirPath, List<CpDataset> cpDatasets, String zipName) {
        this.workDirPath = workDirPath;
        this.cpDatasets = cpDatasets;
        this.zipName = zipName;
    }

    public static void execute(String workDirPath, List<CpDataset> cpDatasets, String zipName) throws Exception {
        CpScriptExecutor cpScriptExecutor = new CpScriptExecutor(workDirPath, cpDatasets, zipName);
        cpScriptExecutor.executeScript();
    }

    public void executeScript() throws Exception {
        File directory = new File(this.workDirPath);
        File tempScriptFile = this.createTempScriptFile(directory);
        this.writeScriptStatementsToFile(tempScriptFile);
        ProcessBuilder processBuilder = new ProcessBuilder(tempScriptFile.getAbsolutePath());
        processBuilder.directory(directory);
        Process process = processBuilder.start();
        this.printProcessStream(process.getInputStream());
        this.printProcessStream(process.getErrorStream());
        int exitCode = process.waitFor();
        if (exitCode > 0) {
            throw new RuntimeException("Copy from Datasets failed with exit code " + exitCode);
        }
    }

    private File createTempScriptFile(File directory) throws IOException {
        File tempFile = File.createTempFile(BUZTOOL_TEMP, SH, directory);
        tempFile.deleteOnExit();
        if (!tempFile.setExecutable(true, true)) {
            throw new RuntimeException(" [Error] Failed to set execute permissions for file " + tempFile.getCanonicalPath());
        }
        return tempFile;
    }

    private void writeScriptStatementsToFile(File tempFile) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tempFile));){
            bufferedWriter.append(BIN_SH);
            bufferedWriter.newLine();
            this.writeCpCommands(bufferedWriter);
            this.writeZipCommand(bufferedWriter);
        }
    }

    private void writeCpCommands(BufferedWriter bufferedWriter) throws IOException {
        for (CpDataset cpDataset : this.cpDatasets) {
            if (cpDataset.getDsType().equals("PDS")) {
                this.writeCpCommandForPdsDataset(bufferedWriter, cpDataset);
                continue;
            }
            this.writeCpCommandForSequentialDataset(bufferedWriter, cpDataset);
        }
    }

    private void writeZipCommand(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.append("tar -cf ").append(this.zipName);
        for (CpDataset cpDataset : this.cpDatasets) {
            bufferedWriter.append(SPACE).append(cpDataset.getName());
        }
        this.addCommandCheck(bufferedWriter);
    }

    private void writeCpCommandForPdsDataset(BufferedWriter bufferedWriter, CpDataset cpDataset) throws IOException {
        if (cpDataset.getMembers().isEmpty()) {
            System.out.println(" [INFO] Dataset " + cpDataset.getName() + " is an empty PDS.");
            return;
        }
        String pdsDir = this.workDirPath + File.separator + cpDataset.getName();
        if (!new File(pdsDir).mkdir()) {
            throw new RuntimeException("Failed to create directory " + pdsDir);
        }
        for (String member : cpDataset.getMembers()) {
            String cpCommand = this.getCpCommand(cpDataset.getName() + OPEN_PARENTHESIS + member + CLOSED_PARENTHESIS, pdsDir + File.separator + member, cpDataset.getCpOption());
            bufferedWriter.append(cpCommand);
            this.addCommandCheck(bufferedWriter);
        }
    }

    private void writeCpCommandForSequentialDataset(BufferedWriter bufferedWriter, CpDataset cpDataset) throws IOException {
        String cpCommand = this.getCpCommand(cpDataset.getName(), this.workDirPath + File.separator + cpDataset.getName(), cpDataset.getCpOption());
        bufferedWriter.append(cpCommand);
        this.addCommandCheck(bufferedWriter);
    }

    private String getCpCommand(String src, String dest, String option) {
        return "cp " + option + SPACE + DOUBLE_QUOTE + DOUBLE_SLASHES + SINGLE_QUOTE + src + SINGLE_QUOTE + DOUBLE_QUOTE + SPACE + dest;
    }

    private void addCommandCheck(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.newLine();
        bufferedWriter.append("if [ $? != 0 ] ; then");
        bufferedWriter.newLine();
        bufferedWriter.append("    exit 99");
        bufferedWriter.newLine();
        bufferedWriter.append("fi");
        bufferedWriter.newLine();
    }

    private void printProcessStream(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, IBM_1047));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

