/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.deploy;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class ManifestVersion {
    private ManifestVersion() {
    }

    public static boolean isV2(String manifestPath) throws XMLStreamException, IOException {
        try (InputStream manifestInputStream = Files.newInputStream(Paths.get(manifestPath, new String[0]), new OpenOption[0]);){
            boolean bl = ManifestVersion.isManifestVersion2(manifestInputStream);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isManifestVersion2(InputStream manifestInputStream) throws XMLStreamException {
        boolean isNewPackage = false;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(manifestInputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                String nodeName;
                if (xmlStreamReader.next() != 1 || !"manifest".equalsIgnoreCase(nodeName = xmlStreamReader.getLocalName().trim())) continue;
                String versionValue = XmlHelper.getAttributeValue(xmlStreamReader, "version");
                isNewPackage = versionValue != null && versionValue.equals("v2_0");
                break;
            }
        }
        return isNewPackage;
    }
}

