/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.dataset;

import com.ibm.jzos.DSCB;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.Format8DSCB;
import com.ibm.jzos.ZFile;

public class DscbInfo {
    private final String singleQuotedDsn;
    private final String volser;
    private int dsOrgInteger;
    private int smsFlagInteger;
    private int recordFormatInteger;
    private int recordLength;
    private int blockSize;

    private DscbInfo(String dsName, String volser) {
        this.singleQuotedDsn = "'" + dsName + "'";
        this.volser = volser;
    }

    public static DscbInfo from(String dsnName, String volser) {
        DscbInfo dscbInfo = new DscbInfo(dsnName, volser);
        dscbInfo.setDscbInfo();
        return dscbInfo;
    }

    private void setDscbInfo() {
        DSCB[] dscb = ZFile.readDSCBChain((String)this.singleQuotedDsn, (String)this.volser);
        if (dscb[0] instanceof Format1DSCB) {
            this.recordFormatInteger = ((Format1DSCB)dscb[0]).getDS1RECFM();
            this.dsOrgInteger = ((Format1DSCB)dscb[0]).getDS1DSORG();
            this.smsFlagInteger = ((Format1DSCB)dscb[0]).getDS1SMSFG();
            this.recordLength = ((Format1DSCB)dscb[0]).getDS1LRECL();
            this.blockSize = ((Format1DSCB)dscb[0]).getDS1BLKL();
        } else {
            this.recordFormatInteger = ((Format8DSCB)dscb[0]).getDS1RECFM();
            this.dsOrgInteger = ((Format8DSCB)dscb[0]).getDS1DSORG();
            this.smsFlagInteger = ((Format8DSCB)dscb[0]).getDS1SMSFG();
            this.recordLength = ((Format8DSCB)dscb[0]).getDS1LRECL();
            this.blockSize = ((Format8DSCB)dscb[0]).getDS1BLKL();
        }
    }

    public int getDsOrgInteger() {
        return this.dsOrgInteger;
    }

    public int getSmsFlagInteger() {
        return this.smsFlagInteger;
    }

    public int getRecordFormatInteger() {
        return this.recordFormatInteger;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getBlockSize() {
        return this.blockSize;
    }
}

