/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.deploy;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.Input;
import com.ibm.urbancode.zos.xml.utils.deploy.Inputs;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class InputsNode {
    private final Inputs inputs;
    private boolean isEndOfInputsElement = false;

    private InputsNode(String url) {
        this.inputs = new Inputs(url);
    }

    public static Inputs fromXml(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String url = XmlHelper.getAttributeValue(xmlStreamReader, "url");
        InputsNode inputsNode = new InputsNode(url);
        inputsNode.processInputsElement(xmlStreamReader);
        return inputsNode.getInputs();
    }

    private void processInputsElement(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        while (!this.isEndOfInputsElement && xmlStreamReader.hasNext()) {
            int next = xmlStreamReader.next();
            if (next == 1) {
                this.processStartElement(xmlStreamReader);
                continue;
            }
            if (next != 2) continue;
            this.processEndElement(xmlStreamReader);
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String startNodeName = xmlStreamReader.getLocalName().trim();
        if (!startNodeName.equalsIgnoreCase("input")) {
            throw new XMLStreamException("Unexpected start element found inside <inputs> tag: " + startNodeName);
        }
        Input input = new Input(XmlHelper.getAttributeValue(xmlStreamReader, "name"));
        input.setVersion(XmlHelper.getAttributeValue(xmlStreamReader, "version"));
        input.setUrl(XmlHelper.getAttributeValue(xmlStreamReader, "url"));
        input.setCompileType(XmlHelper.getAttributeValue(xmlStreamReader, "compileType"));
        this.inputs.addInput(input);
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String endNodeName = xmlStreamReader.getLocalName().trim();
        if (endNodeName.equalsIgnoreCase("inputs")) {
            this.isEndOfInputsElement = true;
        } else if (!endNodeName.equalsIgnoreCase("input")) {
            throw new XMLStreamException("Unexpected end element found inside <inputs> tag: " + endNodeName);
        }
    }

    private Inputs getInputs() {
        return this.inputs;
    }
}

