/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.alloc;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.alloc.AllocCommandBuilder;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;

public class DatasetAllocator {
    private final String allocCommand;
    private final String datasetName;

    public DatasetAllocator(AllocCommandBuilder allocCommandBuilder) {
        this.allocCommand = allocCommandBuilder.getAllocCommand();
        this.datasetName = allocCommandBuilder.getDatasetName();
    }

    public String allocate() throws ZFileException {
        if (DatasetHelper.isGDGDatasetWithReference(this.datasetName)) {
            return this.allocateGDGDataset();
        }
        return this.allocateRegularDataset();
    }

    private String allocateRegularDataset() {
        String ddName = ZFile.allocDummyDDName();
        this.allocateDataset(ddName);
        this.freeDD(ddName);
        return this.datasetName;
    }

    private String allocateGDGDataset() throws ZFileException {
        String ddName = ZFile.allocDummyDDName();
        this.allocateDataset(ddName);
        try {
            String string = DatasetHelper.getGDGNameAssignedToDD(ddName);
            return string;
        }
        finally {
            this.freeDD(ddName);
        }
    }

    private void allocateDataset(String ddName) {
        String command = "alloc fi(" + ddName + ") da(" + this.datasetName + ")" + this.allocCommand + " reuse new catalog msg(wtp)";
        System.out.println("Allocate Command: " + command);
        DatasetHelper.allocateDataset(command);
    }

    private void freeDD(String ddName) {
        ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
    }
}

