/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.versions.cleanup;

import com.urbancode.air.plugin.command.versions.cleanup.CommonUtil;
import com.urbancode.air.plugin.command.versions.cleanup.PluginInputs;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import com.urbancode.ud.client.EnvironmentClient;
import java.util.HashMap;
import java.util.Properties;
import org.codehaus.jettison.json.JSONArray;

public class RemoveAllVersions {
    private static final String DELETE_VERSIONS = "deleteVersions";
    private static final String RETAIN_DAYS = "retainDays";
    private final Properties inputProperties;

    public RemoveAllVersions(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() throws Exception {
        try {
            PluginInputs pluginInputs = PluginInputs.getValidatedInputs(this.inputProperties);
            CommonUtil.printComponentInfo(pluginInputs);
            JSONArray versions = pluginInputs.isDryRun() ? this.getVersions(pluginInputs) : this.deleteVersions(pluginInputs);
            if (versions.length() == 0) {
                System.out.println(" [Info] No versions to remove.");
                return 0;
            }
            int count = pluginInputs.isDryRun() ? CommonUtil.printVersionsName(versions) : CommonUtil.deleteVersionsDirectory(versions, pluginInputs.getComponentDeployPath());
            System.out.println("\n Total number of versions - " + count);
            return 0;
        }
        catch (InvalidInputException | MissingInputException e) {
            System.out.println(" [Error] " + e.getMessage());
            return 8;
        }
    }

    private JSONArray deleteVersions(PluginInputs pluginInputs) throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(DELETE_VERSIONS, Boolean.TRUE.toString());
        queryParams.put(RETAIN_DAYS, String.valueOf(pluginInputs.getRetainDays()));
        EnvironmentClient envClient = CommonUtil.getEnvironmentClient();
        return envClient.deleteAllVersions(pluginInputs.getEnvironmentName(), pluginInputs.getApplicationName(), pluginInputs.getComponentName(), queryParams);
    }

    private JSONArray getVersions(PluginInputs pluginInputs) throws Exception {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(DELETE_VERSIONS, Boolean.FALSE.toString());
        queryParams.put(RETAIN_DAYS, String.valueOf(pluginInputs.getRetainDays()));
        EnvironmentClient envClient = CommonUtil.getEnvironmentClient();
        return envClient.deleteAllVersions(pluginInputs.getEnvironmentName(), pluginInputs.getApplicationName(), pluginInputs.getComponentName(), queryParams);
    }
}

