/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.mvs.command;

import com.ibm.urbancode.zos.common.util.StringHelper;
import com.urbancode.air.plugin.command.mvs.command.MvsCommandExecutor;
import com.urbancode.air.plugin.command.mvs.command.MvsCommandInputs;
import com.urbancode.air.plugin.command.mvs.command.MvsCommandOutput;
import com.urbancode.air.plugin.command.mvs.command.NotAuthorizedException;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class MvsCommand {
    static final String NUMBER_OF_COMMANDS_EXECUTED = "numberOfCommandsExecuted";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public MvsCommand(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws Exception {
        try {
            MvsCommandInputs pluginInputs = MvsCommandInputs.getValidatedInputs(this.inputProperties);
            MvsCommandExecutor mvsCommandExecutor = MvsCommandExecutor.createInstance();
            boolean anyMvsCommandFailed = this.executeMvsCommands(pluginInputs, mvsCommandExecutor);
            if (anyMvsCommandFailed) {
                return 1;
            }
            return 0;
        }
        catch (NotAuthorizedException | InvalidInputException | MissingInputException e) {
            System.out.println(" [Error] " + e.getMessage());
            return 1;
        }
    }

    boolean executeMvsCommands(MvsCommandInputs pluginInputs, MvsCommandExecutor mvsCommandExecutor) {
        int numberOfCommandsExecuted = 0;
        List<String> failureMessages = StringHelper.getLines(pluginInputs.getFailMessages());
        boolean anyMvsCommandFailed = false;
        Iterator<String> mvsCommandsIterator = pluginInputs.getMvsCommands().iterator();
        while (mvsCommandsIterator.hasNext()) {
            ++numberOfCommandsExecuted;
            MvsCommandOutput mvsCommandOutput = mvsCommandExecutor.runCommand(mvsCommandsIterator.next());
            if (mvsCommandOutput.getReturnCode() == 0) {
                List<String> isfResponseList = mvsCommandOutput.getIsfResponseList();
                if (MvsCommand.isMvsResponseContainsFailureMessage(isfResponseList, failureMessages)) {
                    anyMvsCommandFailed = true;
                    System.out.println("Step failed.\n");
                }
            } else {
                anyMvsCommandFailed = true;
            }
            if (!anyMvsCommandFailed || !pluginInputs.isStopOnFail() || !mvsCommandsIterator.hasNext()) continue;
            this.printRemainingMvsCommands(mvsCommandsIterator);
        }
        this.outputProperties.setProperty(NUMBER_OF_COMMANDS_EXECUTED, String.valueOf(numberOfCommandsExecuted));
        return anyMvsCommandFailed;
    }

    private void printRemainingMvsCommands(Iterator<String> mvsCommandsIterator) {
        System.out.println("Following commands are not executed because Stop On Fail is set to true.");
        while (mvsCommandsIterator.hasNext()) {
            System.out.println(mvsCommandsIterator.next());
        }
    }

    protected static boolean isMvsResponseContainsFailureMessage(List<String> isfResponseList, List<String> failureMessages) {
        if (failureMessages.isEmpty()) {
            return false;
        }
        boolean containsFailMessage = false;
        System.out.println("===============================");
        for (String isfResponse : isfResponseList) {
            for (String failureMessage : failureMessages) {
                if (!isfResponse.contains(failureMessage)) continue;
                containsFailMessage = true;
                System.out.println("Following line in command response contains fail message : " + failureMessage);
                System.out.println(isfResponse + "\n");
            }
        }
        return containsFailMessage;
    }
}

