/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata.crypto;

import com.urbancode.air.securedata.crypto.MACAlgorithm;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class MACAlgorithmSHA256
implements MACAlgorithm {
    private final String algorithm = "HmacSHA256";
    private final int keyLength = 64;

    MACAlgorithmSHA256() throws GeneralSecurityException {
        this.testAlgorithms();
    }

    public String toString() {
        return this.getName();
    }

    public String getAlgorithm() {
        return "HmacSHA256";
    }

    public int getKeyLength() {
        return 64;
    }

    public String toJavaAlgorithm() {
        return this.getAlgorithm();
    }

    public String getName() {
        return "HMAC:SHA256";
    }

    public Mac createMac() {
        try {
            return Mac.getInstance(this.toJavaAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public SecretKey createKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, this.toJavaAlgorithm());
    }

    private void testAlgorithms() throws GeneralSecurityException {
        Mac.getInstance(this.toJavaAlgorithm());
    }
}

