/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto;

import com.urbancode.commons.util.logging.LogUtil;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FIPSHelper {
    private static final Logger log = Logger.getLogger(FIPSHelper.class);
    public static final String IBM_FIPS_FLAG = "com.ibm.jsse2.usefipsprovider";
    public static final String SSL_SOCKET_FACTORY_PROVIDER = "ssl.SocketFactory.provider";
    public static final String SSL_SERVER_SOCKET_FACTORY_PROVIDER = "ssl.ServerSocketFactory.provider";
    public static final String FIPS_SOCKET_PROVIDER = "com.ibm.jsse2.SSLSocketFactoryImpl";
    public static final String FIPS_SERVER_SOCKET_PROVIDER = "com.ibm.jsse2.SSLServerSocketFactoryImpl";
    public static final String FIPS_JCE_PROVIDER = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static volatile Boolean fipsRequested;
    private static volatile Boolean fipsEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFipsRequested() {
        Boolean fr = fipsRequested;
        if (fr != null) return fr;
        Class<FIPSHelper> clazz = FIPSHelper.class;
        synchronized (FIPSHelper.class) {
            fr = fipsRequested;
            if (fr != null) return fr;
            fipsRequested = fr = Boolean.valueOf(Boolean.getBoolean(IBM_FIPS_FLAG));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFipsEnabled() {
        Boolean fe = fipsEnabled;
        if (fe != null) return fe;
        Class<FIPSHelper> clazz = FIPSHelper.class;
        synchronized (FIPSHelper.class) {
            fe = fipsEnabled;
            if (fe != null) return fe;
            fipsEnabled = fe = Boolean.valueOf(FIPSHelper.initIsFipsEnabled());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fe;
        }
    }

    private static boolean initIsFipsEnabled() {
        boolean result = false;
        if (FIPSHelper.isFipsRequested()) {
            result = true;
            Provider[] providers = Security.getProviders();
            Class<?> ibmjcefips = null;
            try {
                ibmjcefips = Class.forName(FIPS_JCE_PROVIDER);
            }
            catch (Exception e) {
                LogUtil.logDebug(log, "Deploy is configured to run in FIPS-compliant mode, but the IBMJCEFIPS provider was not found!", e);
                result = false;
            }
            if (!providers[0].getClass().equals(ibmjcefips)) {
                LogUtil.logDebug(log, "The IBMJCEFIPS provider was not found at its expected position in the Java provider list.");
                result = false;
            }
            String serverSocketFactory = Security.getProperty(SSL_SERVER_SOCKET_FACTORY_PROVIDER);
            String socketFactory = Security.getProperty(SSL_SOCKET_FACTORY_PROVIDER);
            if (!FIPS_SERVER_SOCKET_PROVIDER.equals(serverSocketFactory) || !FIPS_SOCKET_PROVIDER.equals(socketFactory)) {
                LogUtil.logDebug(log, "Socket Factories are not properly configured for FIPS compliant mode. Found: " + serverSocketFactory + ", " + socketFactory);
                result = false;
            }
        }
        return result;
    }

    public static void enableFips() {
        if (FIPSHelper.isFipsRequested() && !FIPSHelper.isFipsEnabled()) {
            LogUtil.logTrace(log, "Enabling FIPS. Checking Java vendor...");
            String javaVendor = System.getProperty("java.vendor");
            if (!FIPSHelper.isIBMJava()) {
                throw new RuntimeException("IBM Java is required for FIPS compliance, but the detected vendor was " + javaVendor);
            }
            LogUtil.logTrace(log, "IBM Vendor found. Checking Java version...");
            String javaSpecVersion = System.getProperty("java.specification.version");
            int javaSpecVersionInt = Integer.parseInt(javaSpecVersion.substring(2));
            if (javaSpecVersionInt < 6) {
                throw new RuntimeException("To run in FIPS mode, a minimum version of IBM Java 1.6 SR12 is required.");
            }
            if ("1.6".equals(javaSpecVersion)) {
                log.warn((Object)"IBM Java 1.6 detected. Please note that a minimum Service Refresh of 12 is required for this version.");
            }
            LogUtil.logTrace(log, "Found version " + javaSpecVersion + ". Configuring providers...");
            Security.setProperty(SSL_SOCKET_FACTORY_PROVIDER, FIPS_SOCKET_PROVIDER);
            Security.setProperty(SSL_SERVER_SOCKET_FACTORY_PROVIDER, FIPS_SERVER_SOCKET_PROVIDER);
            try {
                Constructor<?> ibmjcefips = Class.forName(FIPS_JCE_PROVIDER).getConstructor(new Class[0]);
                Security.insertProviderAt((Provider)ibmjcefips.newInstance(new Object[0]), 1);
            }
            catch (Exception e) {
                throw new RuntimeException("An error occurred while trying configure the server for FIPS compliance.", e);
            }
            LogUtil.logDebug(log, "FIPS 140-2 Compliant Mode Enabled");
            fipsEnabled = true;
        }
    }

    public static boolean isIBMJava() {
        String javaVendor = System.getProperty("java.vendor");
        return javaVendor != null && javaVendor.toLowerCase(Locale.US).contains("ibm");
    }

    private FIPSHelper() {
    }
}

