/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.manifest;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ManifestWriter {
    private static final String UTF_8 = "UTF-8";
    private static ManifestWriter instance;

    private ManifestWriter() {
    }

    public static ManifestWriter getInstance() {
        if (instance == null) {
            instance = new ManifestWriter();
        }
        return instance;
    }

    public void write(File file, Manifest manifest) throws Exception {
        this.write(file, UTF_8, manifest);
    }

    public void write(File file, String encoding, Manifest manifest) throws Exception {
        try (FileOutputStream stream = new FileOutputStream(file);){
            this.write(stream, encoding, manifest);
        }
    }

    public void write(OutputStream stream, Manifest manifest) throws Exception {
        this.write(stream, UTF_8, manifest);
    }

    public void write(OutputStream stream, String encoding, Manifest manifest) throws Exception {
        this.write(stream, encoding, manifest, false);
    }

    public void write(OutputStream stream, String encoding, Manifest manifest, boolean omitXmlDeclaration) throws Exception {
        StreamResult streamResult = new StreamResult(stream);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("indent", "yes");
        try {
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        serializer.setOutputProperty("encoding", encoding);
        if (omitXmlDeclaration) {
            serializer.setOutputProperty("omit-xml-declaration", "yes");
        }
        hd.setResult(streamResult);
        hd.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        atts.addAttribute("", "", "type", "CDATA", manifest.getType());
        if (null != manifest.getVersion()) {
            atts.addAttribute("", "", "version", "CDATA", manifest.getVersion());
        }
        if (null != manifest.getTimeZone()) {
            atts.addAttribute("", "", "timeZone", "CDATA", manifest.getTimeZone());
        } else {
            manifest.setTimeZone();
            atts.addAttribute("", "", "timeZone", "CDATA", manifest.getTimeZone());
        }
        hd.startElement("", "", "manifest", atts);
        Iterator<Container> containerIterator = manifest.getContainersIterator();
        if (containerIterator.hasNext()) {
            atts.clear();
            this.writeContainers(hd, containerIterator);
        }
        if ((containerIterator = manifest.getCreatedContainersIterator()).hasNext()) {
            atts.clear();
            hd.startElement("", "", "created", atts);
            this.writeContainers(hd, containerIterator);
            hd.endElement("", "", "created");
        }
        if ((containerIterator = manifest.getUpdatedContainersIterator()).hasNext()) {
            atts.clear();
            hd.startElement("", "", "updated", atts);
            this.writeContainers(hd, containerIterator);
            hd.endElement("", "", "updated");
        }
        if ((containerIterator = manifest.getDeletedContainersIterator()).hasNext()) {
            atts.clear();
            hd.startElement("", "", "deleted", atts);
            this.writeContainers(hd, containerIterator);
            hd.endElement("", "", "deleted");
        }
        hd.endElement("", "", "manifest");
        hd.endDocument();
    }

    private void writeContainers(TransformerHandler hd, Iterator<Container> containerIterator) throws SAXException {
        while (containerIterator.hasNext()) {
            String copyType;
            String containerDeployType;
            String rootDir;
            String missing;
            AttributesImpl atts = new AttributesImpl();
            Container container = containerIterator.next();
            atts.addAttribute("", "", "name", "CDATA", container.getName());
            atts.addAttribute("", "", "type", "CDATA", container.getType());
            String changeType = container.getChangeType();
            if (changeType != null) {
                atts.addAttribute("", "", "changeType", "CDATA", container.getChangeType());
            }
            if ("sequential".equals(container.getType())) {
                String workItemUUID;
                String workItemID = container.getWorkItemId();
                if (workItemID != null) {
                    atts.addAttribute("", "", "workItemId", "CDATA", workItemID);
                }
                if ((workItemUUID = container.getWorkitemUUID()) != null) {
                    atts.addAttribute("", "", "workItemUUID", "CDATA", workItemUUID);
                }
            }
            if ((missing = container.getMissing()) != null) {
                atts.addAttribute("", "", "missing", "CDATA", missing);
            }
            if ((rootDir = container.getRootDir()) != null && !rootDir.isEmpty()) {
                atts.addAttribute("", "", "rootDir", "CDATA", rootDir);
            }
            if ((containerDeployType = container.getDeployType()) != null && !containerDeployType.isEmpty()) {
                atts.addAttribute("", "", "deployType", "CDATA", containerDeployType);
            }
            if ((copyType = container.getCopyType()) != null && !copyType.isEmpty()) {
                atts.addAttribute("", "", "copyType", "CDATA", copyType);
            }
            hd.startElement("", "", "container", atts);
            Map<String, String> properties = container.getProperties();
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    atts.clear();
                    atts.addAttribute("", "", "name", "CDATA", entry.getKey());
                    atts.addAttribute("", "", "value", "CDATA", entry.getValue());
                    hd.startElement("", "", "property", atts);
                    hd.endElement("", "", "property");
                }
            }
            Iterator<Resource> resourcesIterator = container.getResourcesIterator();
            while (resourcesIterator.hasNext()) {
                String versionId;
                String deployType;
                String languageDefinitionName;
                String languageDefinitionUUID;
                String packageResultUUID;
                String packageResultLabel;
                String packagename;
                String packageDefinitionUUId;
                String packageDefinitionId;
                String workItemUUID;
                String workItemID;
                String ibmiAttr;
                String ibmiType;
                String lastModifiedTimestamp;
                String creationTimestamp;
                atts.clear();
                Resource resource = resourcesIterator.next();
                atts.addAttribute("", "", "name", "CDATA", resource.getName());
                atts.addAttribute("", "", "type", "CDATA", resource.getType());
                String size = resource.getSize();
                if (size != null) {
                    atts.addAttribute("", "", "size", "CDATA", size);
                }
                if ((creationTimestamp = resource.getCreationTimestamp()) != null) {
                    atts.addAttribute("", "", "creationTimestamp", "CDATA", creationTimestamp);
                }
                if ((lastModifiedTimestamp = resource.getLastModifiedTimestamp()) != null) {
                    atts.addAttribute("", "", "lastModifiedTimestamp", "CDATA", lastModifiedTimestamp);
                }
                if ((ibmiType = resource.getIbmiType()) != null) {
                    atts.addAttribute("", "", "IBMiType", "CDATA", ibmiType);
                }
                if ((ibmiAttr = resource.getIbmiAttrribute()) != null) {
                    atts.addAttribute("", "", "IBMiAttribute", "CDATA", ibmiAttr);
                }
                if ((workItemID = resource.getWorkItemId()) != null) {
                    atts.addAttribute("", "", "workItemId", "CDATA", workItemID);
                }
                if ((workItemUUID = resource.getWorkitemUUID()) != null) {
                    atts.addAttribute("", "", "workItemUUID", "CDATA", workItemUUID);
                }
                if ((packageDefinitionId = resource.getPackageDefinitionId()) != null) {
                    atts.addAttribute("", "", "packageDefinitionId", "CDATA", packageDefinitionId);
                }
                if ((packageDefinitionUUId = resource.getPackageDefinitionUUID()) != null) {
                    atts.addAttribute("", "", "packageDefinitionUUID", "CDATA", packageDefinitionUUId);
                }
                if ((packagename = resource.getPackageName()) != null) {
                    atts.addAttribute("", "", "packageName", "CDATA", packagename);
                }
                if ((packageResultLabel = resource.getPackageResultLabel()) != null) {
                    atts.addAttribute("", "", "packageResultLabel", "CDATA", packageResultLabel);
                }
                if ((packageResultUUID = resource.getPackageResultUUID()) != null) {
                    atts.addAttribute("", "", "packageResultUUID", "CDATA", packageResultUUID);
                }
                if ((languageDefinitionUUID = resource.getLanguageDefinitionUUID()) != null) {
                    atts.addAttribute("", "", "languageDefinitionUUID", "CDATA", languageDefinitionUUID);
                }
                if ((languageDefinitionName = resource.getLanguageDefinitionName()) != null) {
                    atts.addAttribute("", "", "languageDefinitionName", "CDATA", languageDefinitionName);
                }
                if ((deployType = resource.getDeployType()) != null && !deployType.isEmpty()) {
                    atts.addAttribute("", "", "deployType", "CDATA", deployType);
                }
                if ((versionId = resource.getVersionId()) != null && !versionId.isEmpty()) {
                    atts.addAttribute("", "", "versionId", "CDATA", versionId);
                }
                if ((missing = resource.getMissing()) != null) {
                    atts.addAttribute("", "", "missing", "CDATA", missing);
                }
                hd.startElement("", "", "resource", atts);
                properties = resource.getProperties();
                if (properties != null && !properties.isEmpty()) {
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        atts.clear();
                        atts.addAttribute("", "", "name", "CDATA", entry.getKey());
                        atts.addAttribute("", "", "value", "CDATA", entry.getValue());
                        hd.startElement("", "", "property", atts);
                        hd.endElement("", "", "property");
                    }
                }
                hd.endElement("", "", "resource");
            }
            hd.endElement("", "", "container");
        }
    }
}

