/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.automation.v2.CpDataset;
import com.ibm.team.enterprise.automation.v2.CpScriptExecutor;
import com.ibm.team.enterprise.deployment.common.DeltaManifest;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.CopyType;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import com.urbancode.air.plugin.command.version.deployment.BackupDatasetPropertiesXml;
import com.urbancode.air.plugin.command.version.deployment.DeltaDeployedXml;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MvsV2BackupTaker {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final PackageManifest packageManifest;
    private final DeltaManifest deltaManifest;
    private final List<CpDataset> cpDatasets = new ArrayList<CpDataset>();

    public MvsV2BackupTaker(PackageManifest packageManifest) {
        this.packageManifest = packageManifest;
        this.deltaManifest = new DeltaManifest();
        this.deltaManifest.setVersion("v2_0");
    }

    public static void takeBackup(String versionWorkDir) throws Exception {
        String packageManifestPath = versionWorkDir + File.separator + "packageManifest_deploy.xml";
        String containerMapperPath = versionWorkDir + File.separator + "containerMapper.xml";
        PackageManifest packageManifest = PackageManifest.from((String)packageManifestPath, (String)containerMapperPath);
        MvsV2BackupTaker mvsV2BackupTaker = new MvsV2BackupTaker(packageManifest);
        DeltaManifest manifest = mvsV2BackupTaker.createDeltaManifest();
        String deltaDeployedXml = DeltaDeployedXml.from(manifest);
        if (!mvsV2BackupTaker.getCpDatasets().isEmpty()) {
            MvsV2BackupTaker.printBackupDatasets(mvsV2BackupTaker.getCpDatasets());
            String backupDatasetsPropertiesXml = BackupDatasetPropertiesXml.generate(mvsV2BackupTaker.getCpDatasets());
            CpScriptExecutor.execute((String)versionWorkDir, mvsV2BackupTaker.getCpDatasets(), (String)"backup.zip");
            String backupDatasetPropertiesXmlFilePath = versionWorkDir + File.separator + "backupDatasetProperties.xml";
            FileHelper.writeStringToFile(backupDatasetsPropertiesXml, backupDatasetPropertiesXmlFilePath);
        }
        String deltaDeployedXmlFilePath = versionWorkDir + File.separator + "deltaDeployed.xml";
        FileHelper.writeStringToFile(deltaDeployedXml, deltaDeployedXmlFilePath);
    }

    private static void printBackupDatasets(List<CpDataset> cpDatasets) {
        Console.printProcessOutput("Taking backup of below datasets - ");
        cpDatasets.stream().filter(cpDataset -> !cpDataset.isSequentialDataset()).filter(cpDataset -> !cpDataset.getMembers().isEmpty()).map(CpDataset::getName).forEach(Console::printProcessOutput);
        cpDatasets.stream().filter(CpDataset::isSequentialDataset).map(CpDataset::getName).forEach(Console::printProcessOutput);
    }

    private DeltaManifest createDeltaManifest() throws IOException {
        for (Container container : this.packageManifest.getAddedContainers()) {
            if (container.isSequential()) {
                this.processSequentialContainer(container);
                continue;
            }
            if (!container.isPds()) continue;
            this.processPdsContainer(container);
        }
        for (Container container : this.packageManifest.getDeletedContainers()) {
            if (container.isSequential()) {
                this.processDeletedSequentialContainer(container);
                continue;
            }
            if (!container.isPds()) continue;
            this.processDeletedPdsContainer(container);
        }
        return this.deltaManifest;
    }

    private void processSequentialContainer(Container container) throws ZFileException {
        for (String targetDs : container.getTargetContainers()) {
            RollbackContainer deltaContainer = new RollbackContainer(targetDs, ContainerType.SEQUENTIAL);
            deltaContainer.setDeployType(container.getDeployType());
            if (DatasetHelper.isDatasetExist(targetDs)) {
                this.deltaManifest.addUpdatedContainer(deltaContainer);
                CpDataset cpDataset = this.createCpDatasetInstance(deltaContainer, container.getCopyType());
                this.addToCpDatasets(cpDataset);
                continue;
            }
            Console.printProcessOutput("Dataset " + targetDs + " does not exist.");
            deltaContainer.setMissing();
            this.deltaManifest.addCreatedContainer(deltaContainer);
        }
    }

    private void processPdsContainer(Container container) throws IOException {
        for (String targetDs : container.getTargetContainers()) {
            if (DatasetHelper.isDatasetExist(targetDs)) {
                this.addMissingPdsResourcesAsCreated(container, targetDs);
                Map<String, PdsDirectory.MemberInfo.Statistics> memberStats = this.getMemberStatsMap(targetDs);
                this.addUpdatedPdsResources(container, targetDs, memberStats);
                continue;
            }
            Console.printProcessOutput("Dataset " + targetDs + " does not exist.");
            this.addCreatedPdsResources(container, targetDs);
        }
    }

    private void processDeletedSequentialContainer(Container container) throws ZFileException {
        for (String targetDs : container.getTargetContainers()) {
            RollbackContainer deltaContainer = new RollbackContainer(targetDs, ContainerType.SEQUENTIAL);
            deltaContainer.setDeployType(container.getDeployType());
            if (DatasetHelper.isDatasetNotExist(targetDs)) {
                deltaContainer.setMissing();
            } else {
                CpDataset cpDataset = this.createCpDatasetInstance(deltaContainer, container.getCopyType());
                this.addToCpDatasets(cpDataset);
            }
            this.deltaManifest.addDeletedContainer(deltaContainer);
        }
    }

    private void processDeletedPdsContainer(Container container) throws IOException {
        for (String targetDs : container.getTargetContainers()) {
            if (DatasetHelper.isDatasetExist(targetDs)) {
                Map<String, PdsDirectory.MemberInfo.Statistics> memberStats = this.getMemberStatsMap(targetDs);
                this.addDeletedPdsResourcesWithMissingAttribute(container, targetDs, memberStats);
                continue;
            }
            this.addDeletedPdsResources(container, targetDs);
        }
    }

    private void addMissingPdsResourcesAsCreated(Container container, String targetDs) throws ZFileException {
        ArrayList<RollbackResource> createdResources = new ArrayList<RollbackResource>();
        RollbackContainer deltaContainer = new RollbackContainer(targetDs, ContainerType.PDS);
        deltaContainer.setDeployType(container.getDeployType());
        for (Resource resource : container.getResources()) {
            RollbackResource deltaResource = this.getRollbackResourceInstance(container, resource);
            String pdsMember = deltaContainer.getName() + "(" + resource.getName() + ")";
            if (!DatasetHelper.isDatasetNotExist(pdsMember)) continue;
            Console.printProcessOutput(pdsMember + " does not exist.");
            createdResources.add(deltaResource);
        }
        if (!createdResources.isEmpty()) {
            deltaContainer.addResources(createdResources);
            this.deltaManifest.addCreatedContainer(deltaContainer);
        }
    }

    private RollbackResource getRollbackResourceInstance(Container container, Resource resource) {
        RollbackResource deltaResource = new RollbackResource(resource.getName(), resource.getType());
        if (resource.getResourceDeployType() != null) {
            deltaResource.setDeployType(resource.getResourceDeployType());
        } else if (container.getDeployType() != null) {
            deltaResource.setDeployType(container.getDeployType());
        }
        return deltaResource;
    }

    private void addUpdatedPdsResources(Container container, String targetDs, Map<String, PdsDirectory.MemberInfo.Statistics> memberStatsMap) throws ZFileException {
        ArrayList<RollbackResource> updatedResources = new ArrayList<RollbackResource>();
        RollbackContainer deltaContainer = new RollbackContainer(targetDs, ContainerType.PDS);
        deltaContainer.setDeployType(container.getDeployType());
        for (Resource resource2 : container.getResources()) {
            RollbackResource deltaResource = this.getRollbackResourceInstance(container, resource2);
            String pdsMember = deltaContainer.getName() + "(" + resource2.getName() + ")";
            if (!DatasetHelper.isDatasetExist(pdsMember)) continue;
            this.updateMemberModifiedUserTimestamp(memberStatsMap, deltaResource);
            updatedResources.add(deltaResource);
        }
        if (!updatedResources.isEmpty()) {
            deltaContainer.addResources(updatedResources);
            this.deltaManifest.addUpdatedContainer(deltaContainer);
            CpDataset cpDataset = this.createCpDatasetInstance(deltaContainer, container.getCopyType());
            updatedResources.forEach(resource -> cpDataset.addMember(resource.getName()));
            this.addToCpDatasets(cpDataset);
        }
    }

    private void updateMemberModifiedUserTimestamp(Map<String, PdsDirectory.MemberInfo.Statistics> memberStatsMap, RollbackResource resource) {
        PdsDirectory.MemberInfo.Statistics memberStats = memberStatsMap.get(resource.getName());
        if (memberStats != null) {
            resource.setModifiedUser(memberStats.userid.trim());
            resource.setModifiedTimestamp(SIMPLE_DATE_FORMAT.format(memberStats.modificationDate));
        }
    }

    private void addCreatedPdsResources(Container container, String targetDs) {
        RollbackContainer deltaContainer = new RollbackContainer(targetDs, ContainerType.PDS);
        deltaContainer.setDeployType(container.getDeployType());
        deltaContainer.setMissing();
        for (Resource resource : container.getResources()) {
            RollbackResource deltaResource = this.getRollbackResourceInstance(container, resource);
            deltaContainer.addResource(deltaResource);
        }
        this.deltaManifest.addCreatedContainer(deltaContainer);
    }

    private void addDeletedPdsResources(Container container, String targetDs) {
        RollbackContainer deltaContainer = new RollbackContainer(targetDs, ContainerType.PDS);
        deltaContainer.setDeployType(container.getDeployType());
        deltaContainer.setMissing();
        for (Resource resource : container.getResources()) {
            RollbackResource deltaResource = this.getRollbackResourceInstance(container, resource);
            deltaContainer.addResource(deltaResource);
        }
        this.deltaManifest.addDeletedContainer(deltaContainer);
    }

    private void addDeletedPdsResourcesWithMissingAttribute(Container container, String targetDs, Map<String, PdsDirectory.MemberInfo.Statistics> memberStatsMap) throws ZFileException {
        RollbackContainer deltaContainer = new RollbackContainer(targetDs, ContainerType.PDS);
        deltaContainer.setDeployType(container.getDeployType());
        CpDataset cpDataset = this.createCpDatasetInstance(deltaContainer, container.getCopyType());
        for (Resource resource : container.getResources()) {
            RollbackResource deltaResource = this.getRollbackResourceInstance(container, resource);
            String pdsMember = deltaContainer.getName() + "(" + resource.getName() + ")";
            if (DatasetHelper.isDatasetExist(pdsMember)) {
                this.updateMemberModifiedUserTimestamp(memberStatsMap, deltaResource);
                cpDataset.addMember(resource.getName());
            } else {
                Console.printProcessOutput(pdsMember + " does not exist.");
                deltaResource.setMissing();
            }
            deltaContainer.addResource(deltaResource);
        }
        if (!cpDataset.getMembers().isEmpty()) {
            this.addToCpDatasets(cpDataset);
        }
        this.deltaManifest.addDeletedContainer(deltaContainer);
    }

    private void addToCpDatasets(CpDataset newCpDataset) {
        Optional<CpDataset> cpDatasetOptional = this.getExistingCpDataset(newCpDataset);
        if (cpDatasetOptional.isPresent()) {
            if (newCpDataset.isSequentialDataset()) {
                throw new IllegalArgumentException("Target dataset " + newCpDataset.getName() + " mapped twice for different source datasets");
            }
            CpDataset existingCpDataset = cpDatasetOptional.get();
            existingCpDataset.addMembers((Collection)newCpDataset.getMembers());
        } else {
            this.cpDatasets.add(newCpDataset);
        }
    }

    private Optional<CpDataset> getExistingCpDataset(CpDataset newCpDataset) {
        return this.cpDatasets.stream().filter(cpDataset -> cpDataset.getName().equals(newCpDataset.getName())).findFirst();
    }

    private CpDataset createCpDatasetInstance(RollbackContainer deltaContainer, CopyType copyType) {
        return new CpDataset(deltaContainer.getName(), deltaContainer.getType().toString(), copyType.getCpOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PdsDirectory.MemberInfo.Statistics> getMemberStatsMap(String dataset) throws IOException {
        String slashSlashQuotedDsn = ZFile.getSlashSlashQuotedDSN((String)dataset, (boolean)true);
        HashMap<String, PdsDirectory.MemberInfo.Statistics> memberStatsMap = new HashMap<String, PdsDirectory.MemberInfo.Statistics>();
        try (PdsDirectory pdsDirectory = new PdsDirectory(slashSlashQuotedDsn);){
            for (PdsDirectory.MemberInfo memberInfo : pdsDirectory) {
                if (memberInfo.isAlias()) continue;
                PdsDirectory.MemberInfo.Statistics memberInfoStatistics = memberInfo.getStatistics();
                memberStatsMap.put(memberInfo.getName(), memberInfoStatistics);
            }
        }
        return memberStatsMap;
    }

    public List<CpDataset> getCpDatasets() {
        return this.cpDatasets;
    }
}

