/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public final class TempDsnNameHelper {
    private static final String TIMESTAMP_FORMAT = "HHmmss.SSS";

    private TempDsnNameHelper() {
    }

    public static String getCopyDsnName(String dsnPrefix) {
        return TempDsnNameHelper.generateUniqueDatasetName(dsnPrefix, ".BUZCP.");
    }

    public static String getActionDsnName(String dsnPrefix) {
        return TempDsnNameHelper.generateUniqueDatasetName(dsnPrefix, ".BUZACTN.");
    }

    public static String getStatsDsnName(String dsnPrefix) {
        return TempDsnNameHelper.generateUniqueDatasetName(dsnPrefix, ".BUZSTATU.");
    }

    public static String getRexxDsnName(String dsnPrefix) {
        return TempDsnNameHelper.generateUniqueDatasetName(dsnPrefix, ".BUZREXX.");
    }

    public static String getXmitDsnName(String dsnPrefix) {
        return TempDsnNameHelper.generateUniqueDatasetName(dsnPrefix, ".BUZXMIT.");
    }

    public static String getXmitProgramInputDsnName(String dsnPrefix) {
        return TempDsnNameHelper.generateUniqueDatasetName(dsnPrefix, ".BUZIXMIT.");
    }

    public static String getReceiveDataset(String dsnPrefix) {
        return TempDsnNameHelper.generateUniqueDatasetName(dsnPrefix, ".BUZRECV.");
    }

    private static String generateUniqueDatasetName(String dsnPrefix, String middleQualifier) {
        return dsnPrefix + middleQualifier + TempDsnNameHelper.generateUniqueLowLevelQualifiers();
    }

    private static String generateUniqueLowLevelQualifiers() {
        Random secureRandom = TempDsnNameHelper.getSecureRandom();
        int randomNumber = secureRandom.nextInt(1000);
        String formattedDate = new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date());
        return "T" + formattedDate.substring(0, 6) + ".M" + formattedDate.substring(7) + "R" + randomNumber;
    }

    private static Random getSecureRandom() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
    }
}

