/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.manifest;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ManifestHandler
extends DefaultHandler {
    private Manifest manifest;
    private List<Container> currentContainerList = null;
    private Container currentContainer = null;
    private Resource currentResource = null;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase("manifest")) {
            this.processManifestElement(attributes);
        } else if (qName.equals("created")) {
            this.currentContainerList = this.manifest.getCreatedContainers();
        } else if (qName.equals("updated")) {
            this.currentContainerList = this.manifest.getUpdatedContainers();
        } else if (qName.equals("deleted")) {
            this.currentContainerList = this.manifest.getDeletedContainers();
        } else if (qName.equals("container")) {
            this.processContainerElement(attributes);
        } else if (qName.equals("resource")) {
            this.processResourceElement(attributes);
        } else if (qName.equals("property")) {
            this.processPropertyElement(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("created".equals(qName) || "updated".equals(qName) || "deleted".equals(qName)) {
            this.currentContainerList = null;
        } else if ("resource".equals(qName)) {
            this.currentResource = null;
        } else if ("container".equals(qName)) {
            this.currentContainer = null;
        }
    }

    private void processManifestElement(Attributes attributes) {
        this.manifest = new Manifest();
        this.manifest.setType(attributes.getValue("type"));
        this.manifest.setVersion(attributes.getValue("version"));
        this.manifest.setTimeZone(attributes.getValue("timeZone"));
    }

    private void processContainerElement(Attributes attributes) {
        String copyType;
        String deployType;
        String rootDir;
        String missing;
        String workItemUUID;
        String workItemId;
        Container container = new Container();
        container.setName(attributes.getValue("name"));
        container.setType(attributes.getValue("type"));
        String changeType = attributes.getValue("changeType");
        if (changeType != null && !changeType.isEmpty()) {
            container.setChangeType(changeType);
        }
        if ((workItemId = attributes.getValue("workItemId")) != null && !workItemId.isEmpty()) {
            container.setWorkItemId(workItemId);
        }
        if ((workItemUUID = attributes.getValue("workItemUUID")) != null && !workItemUUID.isEmpty()) {
            container.setWorkitemUUID(workItemUUID);
        }
        if ((missing = attributes.getValue("missing")) != null && !missing.isEmpty()) {
            container.setMissing(missing);
        }
        if ((rootDir = attributes.getValue("rootDir")) != null) {
            container.setRootDir(rootDir);
        }
        if ((deployType = attributes.getValue("deployType")) != null) {
            container.setDeployType(deployType);
        }
        if ((copyType = attributes.getValue("copyType")) != null) {
            container.setCopyType(copyType);
        }
        if (this.currentContainerList == null) {
            this.currentContainerList = this.manifest.getContainers();
        }
        this.currentContainerList.add(container);
        this.currentContainer = container;
    }

    private void processResourceElement(Attributes attributes) {
        String missing;
        String versionId;
        String deployType;
        String languageDefinitionUUID;
        String languageDefinitionName;
        String workItemUUID;
        String workItemId;
        String tag;
        String size;
        String IBMiAttribute;
        String IBMiType;
        String lastModifiedTimestamp;
        Resource resource = new Resource();
        resource.setName(attributes.getValue("name"));
        resource.setType(attributes.getValue("type"));
        String creationTimestamp = attributes.getValue("creationTimestamp");
        if (creationTimestamp != null && !creationTimestamp.isEmpty()) {
            resource.setCreationTimestamp(creationTimestamp);
        }
        if ((lastModifiedTimestamp = attributes.getValue("lastModifiedTimestamp")) != null && !lastModifiedTimestamp.isEmpty()) {
            resource.setLastModifiedTimestamp(lastModifiedTimestamp);
        }
        if ((IBMiType = attributes.getValue("IBMiType")) != null && !IBMiType.isEmpty()) {
            resource.setIbmiType(IBMiType);
        }
        if ((IBMiAttribute = attributes.getValue("IBMiAttribute")) != null && !IBMiAttribute.isEmpty()) {
            resource.setIbmiAttrribute(IBMiAttribute);
        }
        if ((size = attributes.getValue("size")) != null && !size.isEmpty()) {
            resource.setSize(size);
        }
        if ((tag = attributes.getValue("tag")) != null && !tag.isEmpty()) {
            resource.setTag(tag);
        }
        if ((workItemId = attributes.getValue("workItemId")) != null && !workItemId.isEmpty()) {
            resource.setWorkItemId(workItemId);
        }
        if ((workItemUUID = attributes.getValue("workItemUUID")) != null && !workItemUUID.isEmpty()) {
            resource.setWorkitemUUID(workItemUUID);
        }
        if ((languageDefinitionName = attributes.getValue("languageDefinitionName")) != null && !languageDefinitionName.isEmpty()) {
            resource.setLanguageDefinitionName(languageDefinitionName);
        }
        if ((languageDefinitionUUID = attributes.getValue("languageDefinitionUUID")) != null && !languageDefinitionUUID.isEmpty()) {
            resource.setLanguageDefinitionUUID(languageDefinitionUUID);
        }
        if ((deployType = attributes.getValue("deployType")) != null && !deployType.isEmpty()) {
            resource.setDeployType(deployType);
        }
        if ((versionId = attributes.getValue("versionId")) != null && !versionId.isEmpty()) {
            resource.setVersionId(versionId);
        }
        if ((missing = attributes.getValue("missing")) != null && !missing.isEmpty()) {
            resource.setMissing(missing);
        }
        this.currentContainerList.get(this.currentContainerList.size() - 1).addResource(resource);
        this.currentResource = resource;
    }

    private void processPropertyElement(Attributes attributes) {
        Map<Object, Object> properties = new HashMap();
        if (this.currentResource != null) {
            properties = this.currentResource.getProperties();
            if (properties == null) {
                properties = new HashMap();
                this.currentResource.setProperties(properties);
            }
        } else if (this.currentContainer != null && (properties = this.currentContainer.getProperties()) == null) {
            properties = new HashMap();
            this.currentContainer.setProperties(properties);
        }
        String name = attributes.getValue("name");
        String value = attributes.getValue("value");
        if (name != null && !name.isEmpty() && value != null) {
            properties.put(name, value);
        }
    }

    public Manifest getManifest() {
        return this.manifest;
    }
}

