/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.binder.jni;

import com.ibm.teamz.build.binder.jni.BinderException;

public class BinderInfo {
    private static final String SHARED_LIBRARY = "BinderAPIExec";
    private static final String SHARED_LIBRARY_64 = "BinderAPIExec64";
    private static final String VM_BIT_MODE = "com.ibm.vm.bitmode";
    private static final String BIT_MODE_64 = "64";
    private static final int MAX_PDS_LENGTH = 44;
    private static final int MAX_MEMBER_LENGTH = 8;
    private static final int MAX_FILE_PATH_LENGTH = 4096;
    private static final String MODULE_INFO_SEPARATOR = "/";
    private static final String ERROR_LABEL = "error:";
    private String moduleBound;
    private String moduleSize;

    private BinderInfo() {
    }

    public static BinderInfo from(String targetPDS, String memberName, String tempCFilePath) {
        BinderInfo.validateInput("PDS name", targetPDS, 44);
        BinderInfo.validateInput("Member name", memberName, 8);
        BinderInfo.validateInput("Temp file path", tempCFilePath, 4096);
        BinderInfo binderInfo = new BinderInfo();
        try {
            byte[] binderOutputBytes = binderInfo.getBinderInfo(targetPDS.getBytes(), memberName.getBytes(), tempCFilePath.getBytes());
            String binderOutput = new String(binderOutputBytes);
            if (binderOutput.contains(ERROR_LABEL)) {
                throw new BinderException(binderOutput);
            }
            binderInfo.setModuleAttributes(binderOutput);
        }
        catch (BinderException binderException) {
            System.out.println("Failed to fetch binder information for " + targetPDS + "(" + memberName + ")");
            throw binderException;
        }
        return binderInfo;
    }

    private void setModuleAttributes(String binderOutput) {
        String[] moduleDetails = binderOutput.split(MODULE_INFO_SEPARATOR);
        this.moduleBound = moduleDetails[0];
        this.moduleSize = moduleDetails[1];
    }

    private static void validateInput(String inputName, String inputValue, int maxLength) {
        if (inputValue.isEmpty()) {
            throw new IllegalArgumentException(inputName + " is empty.");
        }
        if (inputValue.length() > maxLength) {
            throw new IllegalArgumentException(inputName + " '" + inputValue + "' is more than " + maxLength + " characters.");
        }
    }

    private native byte[] getBinderInfo(byte[] var1, byte[] var2, byte[] var3);

    public String getModuleBound() {
        return this.moduleBound;
    }

    public String getModuleSize() {
        return this.moduleSize;
    }

    static {
        String bitMode = System.getProperty(VM_BIT_MODE);
        String sharedLib = BIT_MODE_64.equals(bitMode) ? SHARED_LIBRARY_64 : SHARED_LIBRARY;
        System.loadLibrary(sharedLib);
    }
}

