/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.common.jes;

import com.ibm.urbancode.zos.common.util.LogConfigurator;
import com.ibm.urbancode.zos.jes.passticket.PassTicketGenerator;
import com.urbancode.air.plugin.command.jcl.common.jes.JESJob;
import com.urbancode.air.plugin.command.jcl.common.jes.JMException;
import com.urbancode.air.plugin.command.jcl.common.jes.JmonException;
import com.urbancode.air.plugin.command.jcl.common.jes.JmonInputs;
import com.urbancode.air.plugin.command.jcl.common.jes.JmonProtocol;
import com.urbancode.air.plugin.command.jcl.common.jes.JobDataset;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class JMConnection {
    private static final String DEFAULT_APPL_ID_FOR_JMON = "FEKAPPL";
    private static final int SLEEP_INTERVAL_IN_SECS = 1;
    private static final int SLEEP_INTERVAL_IN_MILLI_SECS = 1000;
    private static final String EOF = "/*EOF";
    private static final String RETURN_INFO_FOR_JCL_ERROR = "JCLERROR";
    private static final String RETURN_STATUS_FOR_COMPLETION = "COMPLETION";
    static final String RACF_ERROR_CODE = "137";
    static final String INCORRECT_PASSWORD_CODE = "125";
    private static final String SUBMIT_CODE = "116";
    private static final String SUBMITTED_JCL_CODE = "115";
    private static final String STATUS_NOT_AVAILABLE_CODE = "123";
    private static final String SUCCESSFUL_HELLO_RESPONSE_CODE = "102";
    static final String UNKNOWN_HOST = "Unknown host : ";
    static final String FAILED_TO_CONNECT = "Failed to connect. ";
    static final String FAILED_TO_GENERATE_PASS_TICKET = "Failed to generate pass ticket. ";
    private static final int SOCKET_TIMEOUT_MILLI_SECS = 900000;
    private JmonProtocol negotiatedProtocol;
    private final Logger logger;
    private final String host;
    private final int portNumber;
    private final boolean useRunId;
    private final String userId;
    private final String password;
    private final boolean isPassTicketAuthentication;
    private final int timeoutInSecs;
    private final int maxReturnCode;
    private final int cutoff;
    private Socket jmonSocket;
    private BufferedReader jmonMessageReceiver;
    private PrintStream jmonMessageSender;
    private JESJob latestJob;
    private String jobId;

    private JMConnection(JmonInputs jmonInputs) {
        this.host = jmonInputs.getHostname().toUpperCase();
        this.portNumber = Integer.parseInt(jmonInputs.getPort());
        this.useRunId = jmonInputs.isUseRunId();
        this.userId = jmonInputs.getUserid();
        this.password = jmonInputs.getPassword();
        this.isPassTicketAuthentication = jmonInputs.isUsePassTicket();
        this.timeoutInSecs = jmonInputs.getTimeoutInSecs();
        this.cutoff = jmonInputs.getCutoff();
        this.maxReturnCode = jmonInputs.getMaxRC();
        this.logger = LogConfigurator.configureLogger(this.getClass());
    }

    public static JMConnection getInstance(JmonInputs jmonInputs) throws IOException {
        JMConnection jmConnection = new JMConnection(jmonInputs);
        jmConnection.establishJmonConnection();
        return jmConnection;
    }

    private void establishJmonConnection() throws IOException {
        this.jmonSocket = this.createSocket(this.host, this.portNumber);
        this.jmonMessageReceiver = this.getJmonMessageReceiver(this.jmonSocket);
        this.jmonMessageSender = this.getJmonMessageSender(this.jmonSocket);
        this.jmonMessageSender.println(JmonProtocol.getConnectCommand());
        String connectResponse = this.jmonMessageReceiver.readLine();
        this.negotiatedProtocol = JmonProtocol.from(connectResponse);
        this.sendHelloCommandToJmon();
        System.out.printf("JMConnection direct connected %s (%s) %s%n", this.host, this.hashCode(), connectResponse);
    }

    private Socket createSocket(String host, int portNumber) throws IOException {
        try {
            Socket socket = new Socket(host, portNumber);
            socket.setSoTimeout(900000);
            return socket;
        }
        catch (UnknownHostException unknownHostException) {
            throw new JmonException(UNKNOWN_HOST + host);
        }
        catch (ConnectException connectException) {
            throw new JmonException(FAILED_TO_CONNECT + connectException.getMessage());
        }
    }

    private BufferedReader getJmonMessageReceiver(Socket socket) throws IOException {
        return new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
    }

    private PrintStream getJmonMessageSender(Socket socket) throws IOException {
        return new PrintStream(socket.getOutputStream(), false, StandardCharsets.UTF_8.toString());
    }

    private void sendHelloCommandToJmon() throws IOException {
        String helloCommand = this.getHelloCommand();
        this.jmonMessageSender.println(helloCommand);
        String helloResponse = this.jmonMessageReceiver.readLine();
        if (!helloResponse.startsWith(SUCCESSFUL_HELLO_RESPONSE_CODE)) {
            if (helloResponse.startsWith(RACF_ERROR_CODE)) {
                throw new JmonException(helloResponse);
            }
            if (helloResponse.startsWith(INCORRECT_PASSWORD_CODE)) {
                throw new JmonException(helloResponse);
            }
            throw new JmonException("Unknown response from hello command - " + helloResponse);
        }
        this.logger.debug(helloResponse);
    }

    private String getHelloCommand() {
        if (this.useRunId) {
            if (!this.negotiatedProtocol.isLaterThan(new JmonProtocol("01", "11"))) {
                throw new JmonException("JMON version must be greater than or equal to 01.12 level to process requests using Agent Id or Impersonation Id.Current JMON level is " + this.negotiatedProtocol.getMajorLevel() + "." + this.negotiatedProtocol.getMinorLevel());
            }
            return "HELLO ";
        }
        if (this.isPassTicketAuthentication) {
            String passTicket = this.generatePassTicket();
            return "HELLO " + this.userId + " " + this.getBase64Password(passTicket);
        }
        return "HELLO " + this.userId + " " + this.getBase64Password(this.password);
    }

    private String generatePassTicket() {
        try {
            return PassTicketGenerator.generate((String)this.userId, (String)DEFAULT_APPL_ID_FOR_JMON);
        }
        catch (Exception e) {
            throw new JmonException(FAILED_TO_GENERATE_PASS_TICKET + e.getMessage());
        }
    }

    private String getBase64Password(String password) {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] base64Bytes = encoder.encode(passwordBytes);
        return new String(base64Bytes, StandardCharsets.UTF_8);
    }

    public String submitJob(String jclString) throws IOException {
        try {
            this.jobId = this.submit(jclString);
        }
        catch (IOException ioException) {
            if (ioException instanceof SocketException) {
                System.out.println(" [INFO] Socket Exception while submitting JCL, reconnecting to JMON and resubmitting the JCL.");
                this.establishJmonConnection();
                this.jobId = this.submit(jclString);
            }
            throw ioException;
        }
        return this.jobId;
    }

    private String submit(String jclString) throws IOException {
        this.jmonMessageSender.println("SUBMIT");
        String submitResponse = this.jmonMessageReceiver.readLine();
        if (!submitResponse.startsWith(SUBMIT_CODE)) {
            throw new JmonException("Unexpected response from SUBMIT command - " + submitResponse);
        }
        this.sendJclStringToJmon(jclString);
        String submittedJclResponse = this.jmonMessageReceiver.readLine();
        if (!submittedJclResponse.startsWith(SUBMITTED_JCL_CODE)) {
            throw new JmonException("Unexpected response after submitting JCL - " + submittedJclResponse);
        }
        String[] responseWords = submittedJclResponse.split(" ");
        return responseWords[2];
    }

    private void sendJclStringToJmon(String jclString) throws IOException {
        try (BufferedReader reader = new BufferedReader(new StringReader(jclString));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.jmonMessageSender.println(line);
            }
        }
        this.jmonMessageSender.println(EOF);
    }

    public InputStream getOutputSDS(String jobId, String dsn, int cutOff) throws IOException {
        try {
            return this.getJobDatasetOutput(jobId, dsn, cutOff);
        }
        catch (IOException e) {
            if (e instanceof SocketException) {
                return this.getJobDatasetOutput(jobId, dsn, cutOff);
            }
            throw e;
        }
    }

    private ByteArrayInputStream getJobDatasetOutput(String jobId, String dsn, int cutOff) throws IOException {
        this.jmonMessageSender.println("GETSDSC " + jobId + " " + dsn + " " + cutOff);
        String getsdscResponse = this.jmonMessageReceiver.readLine();
        if (getsdscResponse.startsWith("133")) {
            StringBuilder buffer = new StringBuilder();
            do {
                buffer.append(getsdscResponse.substring(5)).append("\n");
            } while (!(getsdscResponse = this.jmonMessageReceiver.readLine()).startsWith("167"));
            if (this.negotiatedProtocol.isLaterThan(new JmonProtocol("0110"))) {
                this.jmonMessageReceiver.readLine();
            }
            return new ByteArrayInputStream(buffer.toString().getBytes());
        }
        if (getsdscResponse.startsWith("167")) {
            if (this.negotiatedProtocol.isLaterThan(new JmonProtocol("0110"))) {
                this.jmonMessageReceiver.readLine();
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        throw new JmonException(getsdscResponse.substring(4));
    }

    public void disconnect() throws IOException {
        try {
            this.jmonMessageSender.println("QUIT");
            String quitResponse = this.jmonMessageReceiver.readLine();
            if (quitResponse == null) {
                System.out.println("Disconnect: QUIT sent. No reply. Closing socket.");
            } else if (!quitResponse.startsWith("105")) {
                throw new JmonException("Unexpected response from QUIT command - " + quitResponse);
            }
        }
        finally {
            if (this.jmonSocket != null) {
                this.jmonSocket.close();
            }
        }
    }

    private List<String> getJobStatusLines(String jobId) throws IOException {
        try {
            return this.getJobStatus(jobId);
        }
        catch (IOException e) {
            if (e instanceof SocketException) {
                this.establishJmonConnection();
                return this.getJobStatus(jobId);
            }
            throw e;
        }
    }

    private List<String> getJobStatus(String jobId) throws IOException {
        ArrayList<String> jobStatusLines = new ArrayList<String>();
        this.jmonMessageSender.println("STAT " + jobId);
        String statResponse = this.jmonMessageReceiver.readLine();
        if (statResponse.startsWith("155-") || statResponse.startsWith("145-")) {
            do {
                jobStatusLines.add(statResponse);
            } while (!(statResponse = this.jmonMessageReceiver.readLine()).startsWith("155 End"));
        } else {
            if (statResponse.startsWith(STATUS_NOT_AVAILABLE_CODE)) {
                throw new JmonException(statResponse.substring(4));
            }
            throw new JmonException("JMON sent back following info which violates protocol for STAT command - " + statResponse);
        }
        return jobStatusLines;
    }

    public List<String> sysout(String jobid) throws JMException, IOException {
        try {
            return this.getSysoutLines(jobid);
        }
        catch (IOException e) {
            if (e instanceof SocketException) {
                this.establishJmonConnection();
                return this.getSysoutLines(jobid);
            }
            throw e;
        }
    }

    private List<String> getSysoutLines(String jobid) throws IOException {
        this.jmonMessageSender.println("SYSOUT " + jobid);
        String sysoutResponse = this.jmonMessageReceiver.readLine();
        ArrayList<String> lines = new ArrayList<String>();
        if (sysoutResponse.startsWith("145")) {
            do {
                lines.add(sysoutResponse);
            } while (!(sysoutResponse = this.jmonMessageReceiver.readLine()).startsWith("145 End"));
            return lines;
        }
        throw new JmonException("Data received from JMON for sysout datasets do not follow the JMON protocol, the data received is : " + sysoutResponse + " but expected is 145");
    }

    public JESJob getJob() throws IOException {
        if (this.latestJob == null) {
            this.latestJob = this.getJobFromJmon(this.jobId);
        }
        return this.latestJob;
    }

    private JESJob getJobFromJmon(String jobId) throws IOException {
        this.logger.debug("Fetch job status from JMON");
        List<String> jobStatusLines = this.getJobStatusLines(jobId);
        JESJob job = new JESJob(this);
        job.setJobID(jobId);
        job.setStatus(jobStatusLines);
        return job;
    }

    public boolean isJobFailedWithJclError() throws JMException, IOException, InterruptedException {
        Thread.sleep(1000L);
        this.logger.debug("Checking if Job failed with JCL Error");
        JESJob job = this.getJob();
        if (job == null) {
            throw new JMException("Failed to get job status.");
        }
        return job.isCompleted() && job.getReturnInfo().equals(RETURN_INFO_FOR_JCL_ERROR);
    }

    public void printJobLog() throws IOException, JMException {
        JobDataset[] jobDatasets;
        for (JobDataset jobDataset : jobDatasets = this.getJob().getDatasets()) {
            this.printOutputDataset(jobDataset);
        }
    }

    public void printOnlyGivenDDs(String[] ddList) throws IOException, JMException {
        JobDataset[] jobDatasets;
        for (JobDataset dataset : jobDatasets = this.getJob().getDatasets()) {
            if (!JMConnection.isDDMatched(ddList, dataset.getDDName())) continue;
            this.printOutputDataset(dataset);
        }
    }

    static boolean isDDMatched(String[] ddList, String jobDatasetDDName) {
        return Arrays.stream(ddList).map(String::trim).map(String::toUpperCase).anyMatch(jobDatasetDDName::equals);
    }

    private void printOutputDataset(JobDataset dataset) throws IOException {
        System.out.println("========================================================================================================================");
        System.out.println(dataset.getDescription());
        System.out.println("========================================================================================================================");
        try (InputStream outputSDS = this.getOutputSDS(dataset.getJobId(), dataset.getDsName(), this.cutoff);
             BufferedReader reader = new BufferedReader(new InputStreamReader(outputSDS));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }

    public void printJobDetails() throws JMException, IOException {
        JESJob jesJob = this.getJob();
        System.out.println("JobID=" + jesJob.getJobID());
        System.out.println("JobName=" + jesJob.getJobName());
        System.out.println("JobReturnCode=" + jesJob.getReturnCode());
        System.out.println("JobReturnInfo=" + jesJob.getReturnInfo());
        System.out.println("JobReturnStatus=" + jesJob.getReturnStatus());
    }

    public boolean waitForJob() throws JMException, InterruptedException, IOException {
        this.logger.debug("Will wait for job to complete and attempt to get job details from JMON");
        for (int elapsedTimeInSecs = 0; elapsedTimeInSecs < this.timeoutInSecs; ++elapsedTimeInSecs) {
            this.latestJob = this.getJobFromJmon(this.jobId);
            if (this.latestJob.isCompleted()) {
                if (this.latestJob.getReturnStatus().equals(RETURN_STATUS_FOR_COMPLETION)) {
                    return this.latestJob.getIntReturnCode() <= this.maxReturnCode;
                }
                System.out.println("Job does not end with completion code.");
                return false;
            }
            Thread.sleep(1000L);
        }
        System.out.println("Timeout waiting for job to complete. Timeout=" + this.timeoutInSecs + " seconds.");
        return false;
    }

    JmonProtocol getProtocolLevel() {
        return this.negotiatedProtocol;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }
}

