/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.FileFilterToRegex;
import com.urbancode.commons.util.logging.LogUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FilePatternFileFilter
implements FileFilter {
    private static final Logger log = Logger.getLogger(FilePatternFileFilter.class);
    private final File base;
    private final List<Pattern> includePatterns = new ArrayList<Pattern>();
    private final List<Pattern> excludePatterns = new ArrayList<Pattern>();

    public FilePatternFileFilter(File base, Collection<String> includes, Collection<String> excludes) {
        Pattern pattern;
        this.base = base;
        for (String p : includes) {
            if (FileFilterToRegex.isMatchAll(p)) {
                this.includePatterns.clear();
                break;
            }
            pattern = FileFilterToRegex.convert(p);
            this.includePatterns.add(pattern);
            LogUtil.logTrace(log, String.format("Translated include %s to %s", p, pattern));
        }
        for (String p : excludes) {
            pattern = FileFilterToRegex.convert(p);
            this.excludePatterns.add(pattern);
            LogUtil.logTrace(log, String.format("Translated exclude %s to %s", p, pattern));
        }
    }

    public File getBase() {
        return this.base;
    }

    @Override
    public boolean accept(File file) {
        String path = this.relativize(file);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matching path " + path));
        }
        boolean accepted = false;
        if (this.includePatterns.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tentatively accepting " + path));
            }
            accepted = true;
        } else {
            for (Pattern pattern : this.includePatterns) {
                if (!pattern.matcher(path).matches()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Tentatively accepting " + path));
                }
                accepted = true;
                break;
            }
        }
        if (accepted) {
            for (Pattern pattern : this.excludePatterns) {
                if (!pattern.matcher(path).matches()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Discarding path " + path));
                }
                accepted = false;
                break;
            }
        }
        if (accepted && log.isDebugEnabled()) {
            log.debug((Object)("Accepted path " + path));
        }
        return accepted;
    }

    private String relativize(File file) {
        boolean separatorLength = true;
        int basePathLength = this.base.getPath().length() + 1;
        if (this.base.getPath().equals("/") || this.base.getPath().endsWith(":\\") && this.base.getPath().length() == 3) {
            --basePathLength;
        }
        return file.getPath().substring(basePathLength).replace('\\', '/');
    }
}

