/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.ZFile;
import java.io.BufferedInputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;

public class DatasetHashCalculator {
    private static final int bufferSize = 8192;
    private static final int ERR_REC = 8;
    private static final String hashType = "SHA-256";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHashValue(String datasetName) {
        String hashStr = "";
        BufferedInputStream buffInputStream = null;
        try {
            MessageDigest digester = MessageDigest.getInstance(hashType);
            ZFile zFile = new ZFile("//'" + datasetName + "'", "rb", 1);
            buffInputStream = new BufferedInputStream(zFile.getInputStream());
            byte[] buffer = new byte[8192];
            int length = 0;
            while ((length = buffInputStream.read(buffer)) != -1) {
                digester.update(buffer, 0, length);
            }
            hashStr = Hex.encodeHexString((byte[])digester.digest(), (boolean)false);
            this.closeInputFile(buffInputStream);
        }
        catch (Exception e) {
            this.closeInputFile(buffInputStream);
            e.printStackTrace();
            System.exit(8);
        }
        finally {
            this.closeInputFile(buffInputStream);
        }
        return hashStr;
    }

    private void closeInputFile(BufferedInputStream buffInputStream) {
        if (buffInputStream == null) {
            return;
        }
        try {
            buffInputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(8);
        }
    }
}

