/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class ContainerFilterMatcher {
    private static final String FORWARD_SLASH = "/";

    private ContainerFilterMatcher() {
    }

    public static List<String> getFilteredDatasets(List<String> containerFilters, Set<String> containerDatasets) {
        ArrayList<String> filteredDsNames = new ArrayList<String>();
        for (String containerFilterLine : containerFilters) {
            if (ContainerFilterMatcher.isRegEx(containerFilterLine = containerFilterLine.trim())) {
                String regexPattern = containerFilterLine.substring(1, containerFilterLine.length() - 1);
                for (String dsName : containerDatasets) {
                    if (!dsName.matches(regexPattern)) continue;
                    filteredDsNames.add(dsName);
                }
                continue;
            }
            if (!containerDatasets.contains(containerFilterLine)) continue;
            filteredDsNames.add(containerFilterLine);
        }
        return filteredDsNames;
    }

    private static boolean isRegEx(String containerFilterLine) {
        return containerFilterLine.startsWith(FORWARD_SLASH) && containerFilterLine.endsWith(FORWARD_SLASH);
    }
}

