/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.rollback;

import com.ibm.team.enterprise.deployment.common.PackageManifestUtil;
import com.ibm.team.enterprise.deployment.hfs.DeployFilesTask;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.ibm.urbancode.zos.xml.utils.deploy.ContainerMap;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.zinventory.ZInventoryTable;
import com.urbancode.air.plugin.command.version.common.AntHelper;
import com.urbancode.air.plugin.command.version.common.CheckAccessExecutor;
import com.urbancode.air.plugin.command.version.mappings.ContainerMapperHfsXml;
import com.urbancode.air.plugin.command.version.mappings.HfsMapper;
import com.urbancode.air.plugin.command.version.mappings.HfsMappingResolver;
import com.urbancode.air.plugin.command.version.rollback.RiskyArtifact;
import com.urbancode.air.plugin.command.version.rollback.RiskyArtifactHelper;
import com.urbancode.air.plugin.command.version.rollback.RollbackManifestGenerator;
import com.urbancode.air.plugin.command.version.rollback.RollbackPackageInputs;
import com.urbancode.air.plugin.command.version.rollback.RollbackRexxExecutor;
import com.urbancode.air.plugin.command.version.rollback.RollbackV2RexxExecutor;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.EnvironmentClient;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RollbackPackage {
    private static final String ERROR_INFO = " does not exist or is not a file. Error rolling back because one of the files needed for rollback is not found. Please make sure you have deployed the version successfully and haven't rolled back it already.";
    private final Properties inputProperties;
    private final Properties outputProperties;
    private RollbackPackageInputs pluginInputs;

    public RollbackPackage(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            this.pluginInputs = RollbackPackageInputs.getValidatedInputs(this.inputProperties);
            DeployedVersion deployedVersion = this.pluginInputs.getDeployedVersion();
            if (!deployedVersion.exist()) {
                throw new InvalidInputException("Please make sure you have deployed the version successfully and haven't rolled back it already.");
            }
            PackageManifest packageManifestXml = PackageManifest.from((String)(deployedVersion.getVersionDirPath() + File.separator + "packageManifest.xml"));
            if (packageManifestXml.hasOnlyGenericArtifacts()) {
                Console.printActionTitle("No artifacts to rollback. Version contains only generic artifacts.");
                return 0;
            }
            if (this.pluginInputs.isPreventRiskyRollbackEnabled()) {
                this.checkRiskForRollback();
            } else {
                Console.printProcessOutput(" [INFO] Prevent risky rollback is disabled. Risk checking is skipped.");
            }
            if (this.pluginInputs.isDryRunEnabled()) {
                Console.printProcessOutput("Dry run completed. Nothing is deployed.");
            } else {
                this.performRollback();
            }
            return 0;
        }
        catch (InvalidInputException invalidInputException) {
            System.out.println(" [Error] " + invalidInputException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private int getComponentHLQLength(RollbackPackageInputs pluginInputs) throws JSONException, IOException, URISyntaxException {
        return UdClientHelper.getComponentClient().getComponent(pluginInputs.getComponentId()).getInt("ignoreQualifiers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRollback() throws Exception {
        String versionWorkDir = this.createVersionWorkingDirectory(this.pluginInputs);
        String deployBasePathForVersion = this.pluginInputs.getDeployedVersion().getVersionDirPath();
        try {
            Console.printActionTitle("Copy backup into working directory:");
            this.copyRollbackManifestXmlFile(deployBasePathForVersion, versionWorkDir);
            this.copyBackupZipFile(deployBasePathForVersion, versionWorkDir);
            this.copyTargetDsListFile(deployBasePathForVersion, versionWorkDir);
            this.copyContainerMapperHFSFile(deployBasePathForVersion, versionWorkDir);
            this.copyBackupDatasetPropertiesFile(deployBasePathForVersion, versionWorkDir);
            this.createPackageManifestForRollback(versionWorkDir);
            PackageManifest packageManifestForRollback = PackageManifest.from((String)(versionWorkDir + File.separator + "rollbackManifest.xml"));
            if (!packageManifestForRollback.hasDataset() && !packageManifestForRollback.hasHFSFile()) {
                System.out.println(" [INFO] No artifacts to be rolled back in this process");
                return;
            }
            if (packageManifestForRollback.hasHFSFile()) {
                String containerMapperHFSFilePath = versionWorkDir + File.separator + "containerMapperHFS.xml";
                if (FileHelper.isFileNotExist(containerMapperHFSFilePath)) {
                    this.createContainerMapperHfsFile(this.pluginInputs.getHfsMapping(), packageManifestForRollback, containerMapperHFSFilePath);
                }
                this.rollbackHFSArtifacts(versionWorkDir, deployBasePathForVersion);
            }
            if (packageManifestForRollback.hasDataset()) {
                this.rollbackMVSArtifacts(this.pluginInputs, packageManifestForRollback, versionWorkDir);
            }
            this.updateRollbackDataInZInventoryTable(this.pluginInputs);
            if (this.pluginInputs.isDeleteBackupFilesEnabled()) {
                this.deleteBackupFiles(deployBasePathForVersion);
            }
        }
        finally {
            FileHelper.cleanDirectory(versionWorkDir);
        }
    }

    private void copyBackupDatasetPropertiesFile(String fromDir, String toDir) throws IOException {
        String backupDatasetPropertiesXmlFilePath = fromDir + File.separator + "backupDatasetProperties.xml";
        if (FileHelper.isFileNotExist(backupDatasetPropertiesXmlFilePath)) {
            return;
        }
        String toBackupDatasetPropertiesXmlFilePath = toDir + File.separator + "backupDatasetProperties.xml";
        FileHelper.copyFile(backupDatasetPropertiesXmlFilePath, toBackupDatasetPropertiesXmlFilePath);
    }

    private void copyContainerMapperHFSFile(String fromDir, String toDir) throws IOException {
        String containerMapperHFSFilePath = fromDir + File.separator + "containerMapperHFS.xml";
        if (FileHelper.isFileNotExist(containerMapperHFSFilePath)) {
            return;
        }
        String toContainerMapperHFSFilePath = toDir + File.separator + "containerMapperHFS.xml";
        FileHelper.copyFile(containerMapperHFSFilePath, toContainerMapperHFSFilePath);
    }

    private void copyTargetDsListFile(String fromDir, String toDir) throws IOException {
        String dsListFilePath = fromDir + File.separator + "dataSetListFile";
        if (FileHelper.isFileNotExist(dsListFilePath)) {
            return;
        }
        String toDsListFilePath = toDir + File.separator + "dataSetListFile";
        FileHelper.copyFile(dsListFilePath, toDsListFilePath);
    }

    private void deleteBackupFiles(String deployBasePathForVersion) throws IOException {
        Console.printActionTitle("Deleting version backup files:");
        FileHelper.cleanDirectory(deployBasePathForVersion);
        System.out.println();
    }

    private void createPackageManifestForRollback(String versionWorkDir) throws XMLStreamException, IOException, JSONException, URISyntaxException {
        String invertedRollbackManifestXml;
        if (this.pluginInputs.shouldRollbackNonRiskyArtifacts()) {
            System.out.println("[INFO] Performing Non risky Rollback");
            JSONArray riskyArtifacts = this.getOverlappingArtifacts(this.pluginInputs);
            PackageManifest packageManifest = this.pluginInputs.getDeployedVersion().getPackageManifest();
            ArrayList<RiskyArtifact> riskyContainersAndResources = new ArrayList<RiskyArtifact>();
            if (packageManifest.hasDataset()) {
                riskyContainersAndResources.addAll(this.getRiskyArtifactsForMvs(riskyArtifacts));
            } else if (packageManifest.hasHFSFile()) {
                riskyContainersAndResources.addAll(this.getRiskyArtifactsForHfs(riskyArtifacts));
            } else {
                throw new UnsupportedOperationException("Rollback Non Risky Artifacts is supported only for HFS and MVS Dataset containers");
            }
            invertedRollbackManifestXml = RollbackManifestGenerator.generateInvertedActionsXml(versionWorkDir + File.separator + "deltaDeployed.xml", riskyContainersAndResources);
        } else {
            invertedRollbackManifestXml = RollbackManifestGenerator.generateInvertedActionsXml(versionWorkDir + File.separator + "deltaDeployed.xml");
        }
        Console.printActionTitle("Inverted manifest generated for rollback:");
        System.out.println(invertedRollbackManifestXml + "\n");
        String toRollbackMfFilePath = versionWorkDir + File.separator + "rollbackManifest.xml";
        FileHelper.writeStringToFile(invertedRollbackManifestXml, toRollbackMfFilePath);
    }

    private List<RiskyArtifact> getRiskyArtifactsForMvs(JSONArray riskyArtifacts) throws JSONException, IOException, URISyntaxException, XMLStreamException {
        Map<String, List<String>> srcTgtDatasetMapping = this.getDatasetContainerMapping(this.pluginInputs.getDeployedVersion().getVersionDirPath());
        int ignoreQualifierLength = this.getComponentHLQLength(this.pluginInputs);
        return RiskyArtifactHelper.getMvsTargetContainerResourceForRiskyArtifacts(riskyArtifacts, srcTgtDatasetMapping, ignoreQualifierLength);
    }

    private List<RiskyArtifact> getRiskyArtifactsForHfs(JSONArray riskyArtifacts) throws JSONException, IOException, XMLStreamException {
        Map<String, List<String>> srcTgtHfsMapping = this.getHfsContainerMapping(this.pluginInputs.getDeployedVersion().getVersionDirPath());
        return RiskyArtifactHelper.getHfsTargetContainerResourceForRiskyArtifacts(riskyArtifacts, srcTgtHfsMapping);
    }

    private void copyBackupZipFile(String fromDir, String toDir) throws IOException {
        String backupZipFilePath = fromDir + File.separator + "backup.zip";
        if (FileHelper.isFileNotExist(backupZipFilePath)) {
            return;
        }
        String toBackupZipFilePath = toDir + File.separator + "backup.zip";
        FileHelper.copyFile(backupZipFilePath, toBackupZipFilePath);
    }

    private void copyRollbackManifestXmlFile(String fromDir, String toDir) throws IOException {
        String rollbackManifestFilePath = fromDir + File.separator + "rollbackManifest.xml";
        if (FileHelper.isFileNotExist(rollbackManifestFilePath)) {
            throw new IllegalArgumentException(rollbackManifestFilePath + ERROR_INFO);
        }
        String deltaDeployedFilePath = toDir + File.separator + "deltaDeployed.xml";
        FileHelper.copyFile(rollbackManifestFilePath, deltaDeployedFilePath);
    }

    private String createVersionWorkingDirectory(RollbackPackageInputs pluginInputs) throws IOException {
        String versionWorkDir = DeploymentFilesHelper.getVersionDirPathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId());
        FileHelper.cleanDirectory(versionWorkDir);
        FileHelper.createDirectory(versionWorkDir);
        return versionWorkDir;
    }

    private void checkAccessForDatasets(String versionWorkDir) throws IOException, InterruptedException {
        Console.printActionTitle("Check access for Rollback action:");
        String dsListFilePath = versionWorkDir + File.separator + "dataSetListFile";
        if (FileHelper.isFileNotExist(dsListFilePath)) {
            Console.printProcessOutput(" [Warning] The target dataset list file is not found, access check is skipped.");
            return;
        }
        CheckAccessExecutor.executeForDatasetsFile(dsListFilePath);
        System.out.println();
    }

    private void updateRollbackDataInZInventoryTable(RollbackPackageInputs pluginInputs) throws IOException, URISyntaxException {
        ZInventoryTable zInventoryTable = new ZInventoryTable(pluginInputs.getVersionId(), pluginInputs.getEnvironmentId());
        if (pluginInputs.shouldRollbackNonRiskyArtifacts()) {
            zInventoryTable.updateForNonRiskyRollback();
        } else {
            zInventoryTable.updateForRollback();
        }
    }

    private void checkRiskForRollback() throws JSONException, URISyntaxException, IOException {
        Console.printActionTitle("Checking risk for rollback.");
        JSONArray overlappingArtifacts = this.getOverlappingArtifacts(this.pluginInputs);
        if (overlappingArtifacts.length() == 0) {
            Console.printProcessOutput("Risk checking passed.");
            return;
        }
        Console.printProcessOutput("Risk checking failed for artifacts:");
        this.printOverlappingArtifacts(overlappingArtifacts);
        this.outputProperties.setProperty("reason", "2");
        this.outputProperties.setProperty("reasonMessage", "Risk found.");
        throw new InvalidInputException("Rollback failed because risk is detected. A risky rollback tries to rollback modules which have been replaced by a subsequent version.");
    }

    private void printOverlappingArtifacts(JSONArray overlappingArtifacts) throws JSONException {
        for (int jsonLoopIndex = 0; jsonLoopIndex < overlappingArtifacts.length(); ++jsonLoopIndex) {
            JSONObject riskyArtifact = overlappingArtifacts.getJSONObject(jsonLoopIndex);
            Console.printProcessOutput("  [" + riskyArtifact.getString("action") + "] " + riskyArtifact.getString("name") + " is replaced by subsequent version:" + riskyArtifact.getString("versionName"));
        }
    }

    private JSONArray getOverlappingArtifacts(RollbackPackageInputs pluginInputs) throws JSONException, URISyntaxException, IOException {
        try {
            EnvironmentClient environmentClient = UdClientHelper.getEnvironmentClient();
            XTrustProvider.install();
            return environmentClient.getOverlappingArtifacts(pluginInputs.getEnvironmentId(), pluginInputs.getComponentId(), pluginInputs.getResourceId(), pluginInputs.getVersionId());
        }
        catch (IOException ioException) {
            if (ioException.getMessage().contains("400 Bad Request") && ioException.getMessage().contains("not deployed")) {
                this.outputProperties.setProperty("reason", "1");
                this.outputProperties.setProperty("reasonMessage", "Version not deployed.");
                throw new InvalidInputException(pluginInputs.getVersionName() + " not deployed");
            }
            throw ioException;
        }
    }

    private void createContainerMapperHfsFile(String hfsMapping, PackageManifest invertedRollbackManifest, String toContainerHFSFilePath) throws IOException, XMLStreamException {
        if (hfsMapping.isEmpty()) {
            throw new IllegalArgumentException("Version contains HFS files. HFS target directory is required.");
        }
        Set<String> hfsNeedToDeploy = PackageManifestUtil.getAllDeployHFSFiles(invertedRollbackManifest);
        HfsMapper hfsMapper = HfsMapper.from(hfsMapping);
        Map<String, String> srcTargetMap = HfsMappingResolver.resolve(hfsMapper, hfsNeedToDeploy);
        String containerMapperHFSXml = ContainerMapperHfsXml.from(srcTargetMap);
        Console.printActionTitle("The containerMapperHFS.xml contents:");
        Console.printProcessOutput(containerMapperHFSXml);
        FileHelper.writeStringToFile(containerMapperHFSXml, toContainerHFSFilePath);
    }

    private void rollbackMVSArtifacts(RollbackPackageInputs pluginInputs, PackageManifest invertedPackageManifest, String versionWorkDir) throws Exception {
        if (pluginInputs.isCheckAccessEnabled()) {
            this.checkAccessForDatasets(versionWorkDir);
        }
        Console.printActionTitle("Rollback data sets:");
        String rollbackManifestFilePath = versionWorkDir + File.separator + "rollbackManifest.xml";
        if (invertedPackageManifest.isNewPackageFormat()) {
            RollbackV2RexxExecutor rollbackV2RexxExecutor = new RollbackV2RexxExecutor(pluginInputs.isPrintLogsEnabled(), pluginInputs.getTempDsnPrefix(), pluginInputs.getIspfGatewayBinPath());
            rollbackV2RexxExecutor.deployFromBackup(rollbackManifestFilePath, versionWorkDir);
        } else {
            RollbackRexxExecutor rollbackRexxExecutor = new RollbackRexxExecutor(pluginInputs.isPrintLogsEnabled(), pluginInputs.getTempDsnPrefix(), pluginInputs.getIspfGatewayBinPath());
            rollbackRexxExecutor.deployFromBackup(rollbackManifestFilePath, versionWorkDir);
        }
    }

    private void rollbackHFSArtifacts(String versionWorkDir, String deployBasePathForVersion) throws Exception {
        Console.printActionTitle("Rollback HFS files:");
        this.untarBackupZipFile(versionWorkDir);
        String containerMapperHFSFilePath = versionWorkDir + File.separator + "containerMapperHFS.xml";
        String artifactsDir = versionWorkDir + File.separator + "unpacked" + File.separator + "HFS";
        String rollbackManifestFilePath = versionWorkDir + File.separator + "rollbackManifest.xml";
        DeployFilesTask deployFilesTask = new DeployFilesTask(artifactsDir, this.isHfsMappingInOldFormat(deployBasePathForVersion));
        deployFilesTask.execute(rollbackManifestFilePath, containerMapperHFSFilePath, false);
    }

    private void untarBackupZipFile(String versionWorkDir) throws IOException {
        String backupZipFilePath = versionWorkDir + File.separator + "backup.zip";
        if (FileHelper.isFileNotExist(backupZipFilePath)) {
            return;
        }
        AntHelper.untar(versionWorkDir + File.separator + "unpacked", backupZipFilePath);
    }

    private boolean isHfsMappingInOldFormat(String deployBasePathForVersion) {
        return FileHelper.isFileNotExist(deployBasePathForVersion + File.separator + "tempFileNewVersion.xml");
    }

    private Map<String, List<String>> getDatasetContainerMapping(String deployBasePathForVersion) throws XMLStreamException, IOException {
        String containerMapperFilePath = deployBasePathForVersion + File.separator + "containerMapper.xml";
        if (!new File(containerMapperFilePath).exists()) {
            throw new RuntimeException("Dataset container Mapper file is missing in " + deployBasePathForVersion);
        }
        return ContainerMap.from((String)containerMapperFilePath).getSourceTargetMap();
    }

    private Map<String, List<String>> getHfsContainerMapping(String deployBasePathForVersion) throws XMLStreamException, IOException {
        String containerMapperFilePath = deployBasePathForVersion + File.separator + "containerMapperHFS.xml";
        if (!new File(containerMapperFilePath).exists()) {
            throw new RuntimeException("Hfs container Mapper file is missing in " + deployBasePathForVersion);
        }
        Map hashMap = ContainerMap.from((String)containerMapperFilePath).getSourceTargetMap();
        return this.removeLeadingFileSeparatorInContainerName(hashMap);
    }

    private Map<String, List<String>> removeLeadingFileSeparatorInContainerName(Map<String, List<String>> hashMap) {
        return hashMap.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("/") ? ((String)e.getKey()).substring(1) : (String)e.getKey(), Map.Entry::getValue));
    }
}

