/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public abstract class NLS {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    private static final String PROP_WARNINGS = "osgi.nls.warnings";
    private static final String IGNORE = "ignore";
    private static final boolean ignoreWarnings;
    private static boolean DEBUG;
    static final int SEVERITY_ERROR = 4;
    static final int SEVERITY_WARNING = 2;
    static final Object ASSIGNED;

    protected NLS() {
    }

    public static String bind(String message, Object binding) {
        return NLS.internalBind(message, null, String.valueOf(binding), null);
    }

    public static String bind(String message, Object binding1, Object binding2) {
        return NLS.internalBind(message, null, String.valueOf(binding1), String.valueOf(binding2));
    }

    public static String bind(String message, Object[] bindings) {
        return NLS.internalBind(message, bindings, null, null);
    }

    public static void initializeMessages(final String baseName, final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            NLS.load(baseName, clazz);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                NLS.load(baseName, clazz);
                return null;
            }
        });
    }

    private static String internalBind(String message, Object[] args, String argZero, String argOne) {
        if (message == null) {
            return "No message available.";
        }
        if (args == null || args.length == 0) {
            args = EMPTY_ARGS;
        }
        int length = message.length();
        int bufLen = length + args.length * 5;
        if (argZero != null) {
            bufLen += argZero.length() - 3;
        }
        if (argOne != null) {
            bufLen += argOne.length() - 3;
        }
        StringBuffer buffer = new StringBuffer(bufLen < 0 ? 0 : bufLen);
        block6: for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        continue block6;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        continue block6;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(message.substring(i, index));
                    }
                    catch (NumberFormatException e) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
                    }
                    if (number == 0 && argZero != null) {
                        buffer.append(argZero);
                    } else if (number == 1 && argOne != null) {
                        buffer.append(argOne);
                    } else {
                        if (number >= args.length || number < 0) {
                            buffer.append("<missing argument>");
                            i = index;
                            continue block6;
                        }
                        buffer.append(args[number]);
                    }
                    i = index;
                    continue block6;
                }
                case '\'': {
                    int nextIndex = i + 1;
                    if (nextIndex >= length) {
                        buffer.append(c);
                        continue block6;
                    }
                    char next = message.charAt(nextIndex);
                    if (next == '\'') {
                        ++i;
                        buffer.append(c);
                        continue block6;
                    }
                    int index = message.indexOf(39, nextIndex);
                    if (index == -1) {
                        buffer.append(c);
                        continue block6;
                    }
                    buffer.append(message.substring(nextIndex, index));
                    i = index;
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add('_' + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        for (int i = 0; i < variants.length; ++i) {
            variants[i] = root + nlSuffixes[i];
        }
        return variants;
    }

    private static void computeMissingMessages(String bundleName, Class<?> clazz, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        int MOD_EXPECTED = 9;
        int MOD_MASK = 25;
        for (Field field : fieldArray) {
            if ((field.getModifiers() & 0x19) != 9 || fieldMap.get(field.getName()) == ASSIGNED) continue;
            try {
                String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                if (DEBUG) {
                    System.out.println(value);
                }
                NLS.log(2, value, null);
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, value);
            }
            catch (Exception e) {
                NLS.log(4, "Error setting the missing message value for: " + field.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(String bundleName, Class<?> clazz) {
        long start = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        for (int i = 0; i < len; ++i) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
        }
        String[] variants = NLS.buildVariants(bundleName);
        for (int i = 0; i < variants.length; ++i) {
            InputStream input;
            InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(variants[i]) : loader.getResourceAsStream(variants[i]);
            if (input == null) continue;
            try {
                MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible);
                properties.load(input);
                continue;
            }
            catch (IOException e) {
                NLS.log(4, "Error loading " + variants[i], e);
                continue;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        NLS.computeMissingMessages(bundleName, clazz, fields, fieldArray, isAccessible);
        if (DEBUG) {
            System.out.println("Time to load message bundle: " + bundleName + " was " + (System.currentTimeMillis() - start) + "ms.");
        }
    }

    static void log(int severity, String message, Exception e) {
        String statusMsg;
        if (severity == 2 && ignoreWarnings) {
            return;
        }
        switch (severity) {
            case 4: {
                statusMsg = "Error: ";
                break;
            }
            default: {
                statusMsg = "Warning: ";
            }
        }
        if (message != null) {
            statusMsg = statusMsg + message;
        }
        if (e != null) {
            statusMsg = statusMsg + ": " + e.getMessage();
        }
        System.err.println(statusMsg);
        if (e != null) {
            e.printStackTrace();
        }
    }

    static {
        ignoreWarnings = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return true;
            }
        });
        DEBUG = false;
        ASSIGNED = new Object();
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map<Object, Object> fields;
        private final boolean isAccessible;

        public MessagesProperties(Map<Object, Object> fieldMap, String bundleName, boolean isAccessible) {
            this.fields = fieldMap;
            this.bundleName = bundleName;
            this.isAccessible = isAccessible;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object fieldObject = this.fields.put(key, ASSIGNED);
            if (fieldObject == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + key + " in: " + this.bundleName;
                if (DEBUG) {
                    System.out.println(msg);
                }
                NLS.log(2, msg, null);
                return null;
            }
            Field field = (Field)fieldObject;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    field.setAccessible(true);
                }
                field.set(null, new String(((String)value).toCharArray()));
            }
            catch (Exception e) {
                NLS.log(4, "Exception setting field value.", e);
            }
            return null;
        }
    }
}

