/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.atomicstate;

import com.urbancode.commons.util.Exceptions;
import com.urbancode.commons.util.assertionerrors.CallDoesNotReturnError;
import com.urbancode.commons.util.atomicstate.PostUpdateAction;
import com.urbancode.commons.util.atomicstate.StateUpdate;
import com.urbancode.commons.util.logging.LogUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class AtomicState<T> {
    private static final Logger log = Logger.getLogger(AtomicState.class);
    private static final ThreadLocal<Boolean> updating = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            if (LogUtil.isTraceEnabled(log)) {
                LogUtil.logTrace(log, "Initializing TLS updating");
            }
            return false;
        }
    };
    private static final ThreadLocal<List<PostUpdateAction>> postUpdateActions = new ThreadLocal<List<PostUpdateAction>>(){

        @Override
        protected List<PostUpdateAction> initialValue() {
            if (LogUtil.isTraceEnabled(log)) {
                LogUtil.logTrace(log, "Initializing TLS postUpdateActions");
            }
            return new LinkedList<PostUpdateAction>();
        }
    };
    private final AtomicReference<T> state;

    public static void addPostUpdateAction(PostUpdateAction action) {
        if (!AtomicState.isUpdating()) {
            throw new IllegalStateException("Tried to add post-update action while not in update");
        }
        postUpdateActions.get().add(action);
        if (LogUtil.isTraceEnabled(log)) {
            LogUtil.logTrace(log, "Post-update action added");
        }
    }

    public static void removePostUpdateActions() {
        if (!AtomicState.isUpdating()) {
            throw new IllegalStateException("Tried to clear post-update actions while not in update");
        }
        postUpdateActions.remove();
        if (LogUtil.isTraceEnabled(log)) {
            LogUtil.logTrace(log, "Removed post-update actions");
        }
    }

    public static boolean isUpdating() {
        boolean result = updating.get();
        if (!result) {
            updating.remove();
        }
        return result;
    }

    private static List<PostUpdateAction> getPostUpdateActions() {
        return postUpdateActions.get();
    }

    private static void beginUpdate() {
        updating.set(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update begun");
        }
    }

    private static void endUpdate() {
        updating.remove();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Update ended");
        }
    }

    public AtomicState(T initialValue) {
        this.state = new AtomicReference<T>(initialValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(StateUpdate<T> update) {
        List<PostUpdateAction> postUpdateActions;
        AtomicState.beginUpdate();
        try {
            try {
                try {
                    T newState;
                    T oldState;
                    int tryCount = 0;
                    do {
                        if (tryCount > 0 && LogUtil.isTraceEnabled(log)) {
                            LogUtil.logTrace(log, "Retrying update after attempt " + tryCount);
                        }
                        AtomicState.removePostUpdateActions();
                        oldState = this.state.get();
                        newState = update.newVersion(oldState);
                        ++tryCount;
                        if (!LogUtil.isTraceEnabled(log)) continue;
                        LogUtil.logTrace(log, "Attempting state update commit...");
                    } while (!this.state.compareAndSet(oldState, newState));
                    if (log.isDebugEnabled()) {
                        LogUtil.logDebug(log, "State update committed after attempt " + tryCount);
                    }
                }
                catch (Throwable t) {
                    try {
                        if (log.isDebugEnabled()) {
                            LogUtil.logDebug(log, "Update aborted by exception");
                        }
                    }
                    finally {
                        Exceptions.throwIt(t);
                    }
                    throw new CallDoesNotReturnError();
                }
                postUpdateActions = AtomicState.getPostUpdateActions();
            }
            finally {
                AtomicState.removePostUpdateActions();
            }
        }
        finally {
            AtomicState.endUpdate();
        }
        try {
            if (log.isDebugEnabled()) {
                LogUtil.logDebug(log, "Executing " + postUpdateActions.size() + " post-update actions");
            }
            for (PostUpdateAction action : postUpdateActions) {
                action.execute();
            }
        }
        catch (Throwable t) {
            Exceptions.throwIt(t);
            throw new CallDoesNotReturnError();
        }
    }

    public final T get() {
        if (AtomicState.isUpdating()) {
            throw new IllegalStateException("Read of current state while in update");
        }
        return this.state.get();
    }
}

