/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs;

import com.urbancode.commons.util.crypto.algs.AbstractCryptAlgorithm;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.log4j.Logger;

public class Crypt1Alg
extends AbstractCryptAlgorithm
implements CryptStringAlgorithm {
    private static final Logger log = Logger.getLogger(Crypt1Alg.class);
    final ThreadLocal<Map<String, Cipher>> cipher;
    final String defaultKeyName;
    final String defaultAlg;
    final Map<String, SecretKey> keysByName;

    public Crypt1Alg(String defaultKeyName, String defaultAlg, Map<String, SecretKey> keys) {
        this.defaultKeyName = defaultKeyName;
        this.defaultAlg = defaultAlg;
        this.keysByName = Collections.unmodifiableMap(new HashMap<String, SecretKey>(keys));
        this.cipher = new ThreadLocal();
    }

    @Override
    public String getAlgPrefix() {
        return "crypt_v1";
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String encode(String value) throws GeneralSecurityException {
        byte[] data = this.getUtf8Bytes(value);
        SecretKey key = this.keysByName.get(this.defaultKeyName);
        if (key == null) {
            throw new IllegalStateException("Did not find encoding key for name " + this.defaultKeyName);
        }
        Cipher cipher = this.getCipher(this.defaultAlg);
        SecureRandom sr = this.getSecureRandom();
        cipher.init(1, (Key)key, sr);
        byte[] iv = cipher.getIV();
        byte[] finalBytes = cipher.doFinal(data);
        return String.format("%s|%s|%s|%s", this.defaultAlg, this.defaultKeyName, iv == null ? "" : this.encodeBase64String(iv), this.encodeBase64String(finalBytes));
    }

    @Override
    public String decode(String encoded) throws GeneralSecurityException {
        List<String> parts = this.split(encoded);
        assert (parts.size() == 4);
        String alg = parts.get(0);
        String keyName = parts.get(1);
        String iv64 = parts.get(2);
        String cipher64 = parts.get(3);
        IvParameterSpec ivspec = null;
        if (iv64.length() > 0) {
            byte[] iv = this.decodeBase64(iv64);
            ivspec = new IvParameterSpec(iv);
        }
        byte[] data = this.decodeBase64(cipher64);
        SecretKey key = this.keysByName.get(keyName);
        if (key == null) {
            key = this.keysByName.get(keyName.toLowerCase());
        }
        if (key == null) {
            log.error((Object)("Did not find any decoding key for name " + keyName));
            throw new InvalidKeyException("Could not find key");
        }
        Cipher cipher = this.getCipher(alg);
        SecureRandom sr = this.getSecureRandom();
        cipher.init(2, (Key)key, ivspec, sr);
        byte[] finalBytes = cipher.doFinal(data);
        return this.toUTF8String(finalBytes);
    }

    private Cipher getCipher(String alg) throws GeneralSecurityException {
        Cipher c;
        Map<String, Cipher> map = this.cipher.get();
        if (map == null) {
            map = new HashMap<String, Cipher>(4);
            this.cipher.set(map);
        }
        if ((c = map.get(alg)) == null) {
            c = Cipher.getInstance(alg);
            map.put(alg, c);
        }
        return c;
    }

    private List<String> split(String toSplit) {
        int curEndIndex;
        ArrayList<String> parts = new ArrayList<String>();
        int curStartIndex = 0;
        while ((curEndIndex = toSplit.indexOf(124, curStartIndex)) != -1) {
            parts.add(toSplit.substring(curStartIndex, curEndIndex));
            curStartIndex = curEndIndex + 1;
        }
        parts.add(toSplit.substring(curStartIndex));
        return parts;
    }

    public String getKeyName(String encoded) {
        List<String> parts = this.split(encoded);
        if (parts.size() != 4) {
            throw new IllegalArgumentException("Value is not encrypted with crypt1alg.");
        }
        return parts.get(1);
    }
}

