/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter.csrf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Whitelist {
    private final List<Pattern> includes;
    private final List<Pattern> excludes;

    Whitelist(List<Pattern> includes, List<Pattern> excludes) {
        this.includes = Collections.unmodifiableList(new ArrayList<Pattern>(includes));
        this.excludes = Collections.unmodifiableList(new ArrayList<Pattern>(excludes));
    }

    public boolean isAccepted(String path) {
        Matcher m;
        boolean result = false;
        for (Pattern p : this.includes) {
            m = p.matcher(path);
            if (!m.matches()) continue;
            result = true;
            break;
        }
        if (result) {
            for (Pattern p : this.excludes) {
                m = p.matcher(path);
                if (!m.matches()) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

