/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

@Deprecated
public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger counter = new AtomicInteger();
    private final String name;
    private final ThreadGroup group;
    private final boolean daemon;

    public NamedThreadFactory(String name, ThreadMode threadMode) {
        this.name = name;
        this.daemon = threadMode == ThreadMode.DAEMON;
        this.group = new NamedThreadGroup(name);
    }

    @Deprecated
    public NamedThreadFactory(String name, boolean daemon) {
        this(name, daemon ? ThreadMode.DAEMON : ThreadMode.NON_DAEMON);
    }

    @Deprecated
    public NamedThreadFactory(String name) {
        this(name, ThreadMode.DAEMON);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        NamedThread thread = new NamedThread(this.group, runnable, this.nextThreadName());
        thread.setDaemon(this.daemon);
        return thread;
    }

    public String getName() {
        return this.name;
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    protected int nextId() {
        return this.counter.getAndIncrement();
    }

    protected String nextThreadName() {
        return this.getName() + "-" + this.nextId();
    }

    private static final class NamedThreadGroup
    extends ThreadGroup {
        private final Logger log;

        NamedThreadGroup(String name) {
            super(name);
            this.log = Logger.getLogger(NamedThreadFactory.class.getName() + "[" + name + "]");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.log.fatal(t + " terminated due to uncaught exception: " + e, e);
        }
    }

    private static final class NamedThread
    extends Thread {
        NamedThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                NDC.remove();
            }
        }
    }

    public static enum ThreadMode {
        DAEMON,
        NON_DAEMON;

    }
}

