/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.EmptyPropertyException;
import com.ibm.urbancode.zos.common.util.PropertyNotFoundException;
import com.ibm.urbancode.zos.common.util.SystemEnv;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class InstalledAgentVersion {
    private static final String INSTALLED_VERSION = "installed.version";
    private static final String CONF = "conf";
    private static final String PERIOD = "\\.";

    public static boolean isGreaterThanOrEqualTo(String agentVersionToCheck) throws IOException {
        return InstalledAgentVersion.isGreaterThanOrEqualTo(InstalledAgentVersion.getAgentToolkitVersion(), agentVersionToCheck);
    }

    protected static boolean isGreaterThanOrEqualTo(String agentVersion, String agentVersionToCheck) {
        String[] agentVersionBits = agentVersion.split(PERIOD);
        int versionNumber = Integer.parseInt(agentVersionBits[0]);
        int releaseNumber = Integer.parseInt(agentVersionBits[1]);
        int modificationNumber = Integer.parseInt(agentVersionBits[2]);
        String[] checkAgentVersionBits = agentVersionToCheck.split(PERIOD);
        int checkVersionNumber = Integer.parseInt(checkAgentVersionBits[0]);
        int checkReleaseNumber = Integer.parseInt(checkAgentVersionBits[1]);
        int checkModificationNumber = Integer.parseInt(checkAgentVersionBits[2]);
        if (versionNumber > checkVersionNumber) {
            return true;
        }
        if (versionNumber < checkVersionNumber) {
            return false;
        }
        if (releaseNumber > checkReleaseNumber) {
            return true;
        }
        if (releaseNumber < checkReleaseNumber) {
            return false;
        }
        return modificationNumber >= checkModificationNumber;
    }

    private static String getAgentToolkitVersion() throws IOException {
        String toolkitBinaryVersionFilePath = SystemEnv.getBuzToolkitHome() + File.separator + CONF + File.separator + INSTALLED_VERSION;
        return InstalledAgentVersion.getInstalledVersion(toolkitBinaryVersionFilePath);
    }

    static String getInstalledVersion(String toolkitBinaryVersionFilePath) throws IOException {
        Properties toolkitProperties = new Properties();
        try (FileInputStream fis = new FileInputStream(toolkitBinaryVersionFilePath);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
            toolkitProperties.load(inputStreamReader);
        }
        if (!toolkitProperties.containsKey(INSTALLED_VERSION)) {
            throw new PropertyNotFoundException("Property installed.version is not found in " + toolkitBinaryVersionFilePath + " file");
        }
        String installedVersion = toolkitProperties.getProperty(INSTALLED_VERSION).trim();
        if (installedVersion.isEmpty()) {
            throw new EmptyPropertyException("Property installed.version is empty in " + toolkitBinaryVersionFilePath + " file");
        }
        return installedVersion;
    }
}

