/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.ContainerMap;
import com.ibm.urbancode.zos.xml.utils.deploy.Input;
import com.ibm.urbancode.zos.xml.utils.deploy.Inputs;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryRequestGenerator {
    private static final String PDS_MEMBER = "PDSMEMBER";
    private static final String USS_FILE = "USSFILE";
    private static final String SEQUENTIAL = "SEQUENTIAL";
    private static final String DELETED = "DELETE";
    private static final String DEPLOY = "DEPLOY";
    private static final String NAME = "name";
    private static final String INPUTS = "inputs";
    private static final String DEPLOY_TYPE = "deploy-type";
    private static final String TARGET_TYPE = "target-type";
    private static final String TARGET = "target";
    private static final String OPERATION_TYPE = "operation-type";
    private static final String INPUTS_URL = "Inputs-url=";
    private static final String SEMI_COLON = " ; ";
    private static final String EMPTY_STRING = "";
    private static final String IGNORE_ZSEARCH_INPUTS = "ignore.zsearch.inputs";
    private static final String DEFAULT_VALUE = "false";
    private static final Predicate<Container> IS_DELETED = Container::isDeleted;
    private static final Predicate<Container> IS_NOT_DELETED = IS_DELETED.negate();
    private ContainerMap datasetContainerMap;
    private ContainerMap hfsContainerMap;
    private final List<JSONObject> resourcesList = new ArrayList<JSONObject>();
    private PackageManifest packageManifestDeploy;
    private final String containerMapperFilePath;
    private final String containerMapperHFSFilePath;
    private final String packageManifestDeployFilePath;
    private final boolean ignoreInputs;

    public ZInventoryRequestGenerator(String componentVersionWorkingDir) {
        this.containerMapperFilePath = componentVersionWorkingDir + File.separator + "containerMapper.xml";
        this.containerMapperHFSFilePath = componentVersionWorkingDir + File.separator + "containerMapperHFS.xml";
        this.packageManifestDeployFilePath = componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        this.ignoreInputs = Boolean.parseBoolean(System.getProperty(IGNORE_ZSEARCH_INPUTS, DEFAULT_VALUE));
    }

    public List<JSONObject> buildRequestPayload() throws XMLStreamException, IOException {
        this.extractDataFromXmlFiles();
        this.packageManifestDeploy.getContainers().stream().filter(IS_NOT_DELETED).forEach(container -> this.addJSONObjectsToResourceList((Container)container, DEPLOY));
        this.packageManifestDeploy.getContainers().stream().filter(IS_DELETED).forEach(container -> this.addJSONObjectsToResourceList((Container)container, DELETED));
        return this.resourcesList;
    }

    private void addJSONObjectsToResourceList(Container originalContainer, String operationType) {
        if (originalContainer.isDirectory()) {
            originalContainer.getResources().forEach(resource -> this.addJSONObjectForDirectoryContainer((Resource)resource, operationType, originalContainer));
        } else if (originalContainer.isPds()) {
            originalContainer.getResources().forEach(resource -> this.addJSONObjectForPdsContainer((Resource)resource, operationType, originalContainer));
        } else if (originalContainer.isSequential()) {
            this.addJSONObjectForSequentialContainer(originalContainer, operationType);
        }
    }

    private void addJSONObjectForDirectoryContainer(Resource resource, String operationType, Container container) {
        JSONObject js = new JSONObject();
        try {
            js.put(NAME, (Object)resource.getName());
            js.put(INPUTS, (Object)this.getInputsForZSearch(resource.getInputs()));
            js.put(OPERATION_TYPE, (Object)operationType);
            js.put(DEPLOY_TYPE, (Object)this.getDeployType(resource));
            js.put(TARGET_TYPE, (Object)USS_FILE);
            js.put(TARGET, this.hfsContainerMap.getTargets(File.separator + container.getSourceContainerName()).get(0));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.resourcesList.add(js);
    }

    private void addJSONObjectForPdsContainer(Resource resource, String operationType, Container container) {
        for (String target : this.datasetContainerMap.getTargets(container.getSourceContainerName())) {
            JSONObject js = new JSONObject();
            try {
                js.put(NAME, (Object)resource.getName());
                js.put(INPUTS, (Object)this.getInputsForZSearch(resource.getInputs()));
                js.put(OPERATION_TYPE, (Object)operationType);
                js.put(DEPLOY_TYPE, (Object)this.getDeployType(resource));
                js.put(TARGET_TYPE, (Object)PDS_MEMBER);
                js.put(TARGET, (Object)target);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            this.resourcesList.add(js);
        }
    }

    private String getDeployType(Resource resource) {
        if (resource.getResourceDeployType() != null) {
            return resource.getResourceDeployType();
        }
        if (resource.getContainerDeployType() != null) {
            return resource.getContainerDeployType();
        }
        return EMPTY_STRING;
    }

    private void addJSONObjectForSequentialContainer(Container sequentialContainer, String operationType) {
        for (String target : this.datasetContainerMap.getTargets(sequentialContainer.getSourceContainerName())) {
            JSONObject js = new JSONObject();
            try {
                js.put(TARGET_TYPE, (Object)SEQUENTIAL);
                js.put(INPUTS, (Object)this.getInputsForZSearch(sequentialContainer.getInputs()));
                js.put(NAME, (Object)sequentialContainer.getSourceContainerName());
                js.put(DEPLOY_TYPE, (Object)(sequentialContainer.getDeployType() == null ? EMPTY_STRING : sequentialContainer.getDeployType()));
                js.put(OPERATION_TYPE, (Object)operationType);
                js.put(TARGET, (Object)target);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            this.resourcesList.add(js);
        }
    }

    private void extractDataFromXmlFiles() throws IOException, XMLStreamException {
        this.packageManifestDeploy = PackageManifest.from((String)this.packageManifestDeployFilePath);
        if (FileHelper.isFileExist(this.containerMapperFilePath)) {
            this.datasetContainerMap = ContainerMap.from((String)this.containerMapperFilePath);
        }
        if (FileHelper.isFileExist(this.containerMapperHFSFilePath)) {
            this.hfsContainerMap = ContainerMap.from((String)this.containerMapperHFSFilePath);
        }
    }

    private String getInputsForZSearch(Inputs inputs) {
        if (this.ignoreInputs || inputs == null) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(inputs.getUrl().isEmpty() ? inputs.getUrl() : "Inputs-url='" + inputs.getUrl() + "'" + SEMI_COLON);
        inputs.getInputs().forEach(input -> builder.append(this.getInputForZSearch((Input)input)));
        return builder.toString();
    }

    private String getInputForZSearch(Input input) {
        return "NAME:- " + input.getName() + ", VERSION:- " + input.getVersion() + ", URL:- '" + input.getUrl() + "', COMPILE_TYPE:- " + input.getCompileType() + SEMI_COLON;
    }
}

