/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.allocate.attributes;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.alloc.AllocGenericCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.command.allocate.attributes.AllocateDatasetInputs;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.util.Properties;

public class AllocateDataset {
    public static final String OUTPUT_PROPERTY_DATASET_NAME = "DatasetName";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public AllocateDataset(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws ZFileException {
        try {
            AllocateDatasetInputs pluginInputs = AllocateDatasetInputs.getValidatedInputs(this.inputProperties);
            if (pluginInputs.isDeleteDatasetEnabled()) {
                DatasetHelper.deleteDataset(pluginInputs.getDatasetName());
            }
            DatasetAllocator allocator = this.getDatasetAllocator(pluginInputs);
            String allocatedDataset = allocator.allocate();
            System.out.println(" [INFO] Dataset " + allocatedDataset + " is created.");
            this.outputProperties.setProperty(OUTPUT_PROPERTY_DATASET_NAME, allocatedDataset);
            return 0;
        }
        catch (InvalidInputException | MissingInputException e) {
            System.out.println(" [Error] " + e.getMessage());
            return 1;
        }
    }

    private DatasetAllocator getDatasetAllocator(AllocateDatasetInputs pluginInputs) {
        AllocGenericCommandBuilder commandBuilder = new AllocGenericCommandBuilder(pluginInputs.getDatasetName()).withVolumeSerial(pluginInputs.getVolumeSerial()).withSpace(pluginInputs.getPrimaryQuantity(), pluginInputs.getSecondaryQuantity()).withSpaceUnit(pluginInputs.getSpaceUnit(), pluginInputs.getRecordLength()).withBlockSize(pluginInputs.getBlockSize()).withAvgRec(pluginInputs.getAverageRECUnit()).withDirectoryBlocks(pluginInputs.getDirectoryBlocks()).withRecordFormat(pluginInputs.getRecordFormat()).withDatasetType(pluginInputs.getDataSetNameType());
        if (this.isSpaceUnitNotBlocks(pluginInputs.getSpaceUnit()) || this.isRecordFormatNotUndefined(pluginInputs.getRecordFormat())) {
            commandBuilder = commandBuilder.withRecordLength(pluginInputs.getRecordLength());
        }
        return commandBuilder.build();
    }

    private boolean isSpaceUnitNotBlocks(String spaceUnit) {
        return !spaceUnit.equals("BLKS");
    }

    private boolean isRecordFormatNotUndefined(String recordFormat) {
        return !recordFormat.equals("U");
    }
}

