/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.common.jes;

import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

public class JmonInputs {
    public static final String SHOW_ALL_THE_OUTPUT = "ALL";
    public static final String USERID = "userid";
    public static final String HOSTNAME = "hostname";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String USE_PASSTICKET = "usePassticket";
    public static final String USE_RUN_ID = "useRunId";
    public static final String TIMEOUT = "timeout";
    public static final String SHOW_OUTPUT = "showOutput";
    public static final String CUT_OFF = "cutOff";
    public static final String MAX_RC = "maxRC";
    public static final String WAIT_FOR_JOB = "waitForJob";
    public static final int JMON_MAX_LINES_LIMIT = 0x7FFFFFF8;
    public static final int DEFAULT_TIMEOUT_IN_SECS = 10;
    public static final String DEFAULT_SHOW_OUTPUT = "ALL";
    public static final int DEFAULT_CUTOFF = 1000;
    public static final int DEFAULT_MAX_RETURN_CODE = 4;
    private final String hostname;
    private final String userid;
    private final String password;
    private final String port;
    private final AuthenticationMethod authenticationMethod;
    private final int timeoutInSecs;
    private final String showOutput;
    private final int cutoff;
    private final int maxRC;

    private JmonInputs(Properties inputProperties) {
        this.hostname = inputProperties.getProperty(HOSTNAME).trim();
        this.userid = inputProperties.getProperty(USERID).trim().toUpperCase();
        this.password = inputProperties.getProperty(PASSWORD).trim();
        this.port = inputProperties.getProperty(PORT).trim();
        this.authenticationMethod = this.getAuthenticationMethod(inputProperties);
        boolean waitForJob = Boolean.parseBoolean(inputProperties.getProperty(WAIT_FOR_JOB).trim());
        if (waitForJob) {
            this.timeoutInSecs = Integer.parseInt(inputProperties.getProperty(TIMEOUT).trim());
            this.showOutput = inputProperties.getProperty(SHOW_OUTPUT).trim();
            this.cutoff = this.getCutoff(inputProperties);
            this.maxRC = Integer.parseInt(inputProperties.getProperty(MAX_RC).trim());
        } else {
            this.timeoutInSecs = 10;
            this.showOutput = "ALL";
            this.cutoff = 1000;
            this.maxRC = 4;
        }
    }

    public static JmonInputs getValidatedInputs(Properties inputProperties) {
        JmonInputs jmonInputs = new JmonInputs(inputProperties);
        jmonInputs.validate();
        return jmonInputs;
    }

    private int getCutoff(Properties inputProperties) {
        int maxLines = Integer.parseInt(inputProperties.getProperty(CUT_OFF).trim());
        if (maxLines < 0) {
            System.out.println(" [Info] Setting Max lines to JMON limit of 2147483640 lines.");
            return 0x7FFFFFF8;
        }
        return maxLines;
    }

    private AuthenticationMethod getAuthenticationMethod(Properties inputProperties) {
        boolean useRunId = Boolean.parseBoolean(inputProperties.getProperty(USE_RUN_ID).trim());
        if (useRunId) {
            return AuthenticationMethod.RUN_ID;
        }
        boolean usePassTicket = Boolean.parseBoolean(inputProperties.getProperty(USE_PASSTICKET).trim());
        return usePassTicket ? AuthenticationMethod.PASS_TICKET : AuthenticationMethod.PASSWORD;
    }

    private void validate() {
        InputsValidator.checkIfEmpty(this.hostname, "Host Name");
        InputsValidator.checkIfEmpty(this.port, "Port");
        if (this.isUsePassword()) {
            InputsValidator.checkIfEmpty(this.userid, "User ID");
            InputsValidator.checkIfEmpty(this.password, "Password");
        }
        if (this.isUsePassTicket()) {
            InputsValidator.checkIfEmpty(this.userid, "User ID");
        }
        if (this.timeoutInSecs < 0) {
            throw new InvalidInputException("Timeout cannot be a negative integer");
        }
        if (this.maxRC < 0) {
            throw new InvalidInputException("Max Return Code cannot be a negative integer");
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isUseRunId() {
        return this.authenticationMethod == AuthenticationMethod.RUN_ID;
    }

    public boolean isUsePassTicket() {
        return this.authenticationMethod == AuthenticationMethod.PASS_TICKET;
    }

    public boolean isUsePassword() {
        return this.authenticationMethod == AuthenticationMethod.PASSWORD;
    }

    public int getTimeoutInSecs() {
        return this.timeoutInSecs;
    }

    public String getShowOutput() {
        return this.showOutput;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public int getMaxRC() {
        return this.maxRC;
    }

    private static enum AuthenticationMethod {
        RUN_ID,
        PASSWORD,
        PASS_TICKET;

    }
}

