/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.team.enterprise.deployment.common.DeltaManifest;
import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import java.io.StringWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DeltaDeployedXml {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private static final String CREATED = "created";
    private static final String UPDATED = "updated";
    private static final String DELETED = "deleted";
    private static final String MANIFEST = "manifest";
    private static final String VERSION = "version";
    private static final String MANIFEST_REPORT = "MANIFEST_REPORT";
    private static final String CONTAINER = "container";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String MISSING = "missing";
    private static final String TRUE = "true";
    private static final String RESOURCE = "resource";
    private static final String PDS = "PDS";
    private static final String SEQUENTIAL = "sequential";
    private static final String DIRECTORY = "directory";
    private static final String DEPLOY_TYPE = "deployType";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private final DeltaManifest deltaManifest;
    private XMLStreamWriter xmlStreamWriter = null;

    private DeltaDeployedXml(DeltaManifest deltaManifest) {
        this.deltaManifest = deltaManifest;
    }

    public static String from(DeltaManifest deltaManifest) throws XMLStreamException {
        DeltaDeployedXml deltaDeployedXml = new DeltaDeployedXml(deltaManifest);
        return deltaDeployedXml.create();
    }

    private String create() throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements();
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements() throws XMLStreamException {
        this.writeXmlHeaderTag();
        this.writeStartingManifestTag();
        this.writeCreatedContainers();
        this.writeUpdatedContainers();
        this.writeDeletedContainers();
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeCreatedContainers() throws XMLStreamException {
        this.writeStartingTag(CREATED);
        for (RollbackContainer createdContainer : this.deltaManifest.getCreatedContainers()) {
            this.writeContainerTag(createdContainer);
        }
        this.writeEndingTag();
    }

    private void writeUpdatedContainers() throws XMLStreamException {
        this.writeStartingTag(UPDATED);
        for (RollbackContainer updatedContainer : this.deltaManifest.getUpdatedContainers()) {
            this.writeContainerTag(updatedContainer);
        }
        this.writeEndingTag();
    }

    private void writeDeletedContainers() throws XMLStreamException {
        this.writeStartingTag(DELETED);
        for (RollbackContainer deletedContainer : this.deltaManifest.getDeletedContainers()) {
            this.writeContainerTag(deletedContainer);
        }
        this.writeEndingTag();
    }

    private void writeXmlHeaderTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingManifestTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(MANIFEST);
        this.xmlStreamWriter.writeAttribute(TYPE, MANIFEST_REPORT);
        if (this.deltaManifest.getVersion() != null) {
            this.xmlStreamWriter.writeAttribute(VERSION, this.deltaManifest.getVersion());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainerTag(RollbackContainer rollbackContainer) throws XMLStreamException {
        this.writeStartingContainerTag(rollbackContainer);
        for (RollbackResource rollbackResource : rollbackContainer.getResources()) {
            this.writeSelfClosingResourceTag(rollbackResource);
        }
        this.writeEndingTag();
    }

    private void writeStartingContainerTag(RollbackContainer rollbackContainer) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(CONTAINER);
        this.xmlStreamWriter.writeAttribute(NAME, rollbackContainer.getName());
        this.xmlStreamWriter.writeAttribute(TYPE, this.getContainerType(rollbackContainer.getType()));
        if (rollbackContainer.isMissing()) {
            this.xmlStreamWriter.writeAttribute(MISSING, TRUE);
        }
        if (rollbackContainer.getDeployType() != null) {
            this.xmlStreamWriter.writeAttribute(DEPLOY_TYPE, rollbackContainer.getDeployType());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private String getContainerType(ContainerType type) {
        if (type == ContainerType.PDS) {
            return PDS;
        }
        if (type == ContainerType.SEQUENTIAL) {
            return SEQUENTIAL;
        }
        if (type == ContainerType.DIRECTORY) {
            return DIRECTORY;
        }
        throw new IllegalArgumentException("Unsupported container type found " + type);
    }

    private void writeSelfClosingResourceTag(RollbackResource rollbackResource) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
        this.xmlStreamWriter.writeEmptyElement(RESOURCE);
        this.xmlStreamWriter.writeAttribute(NAME, rollbackResource.getName());
        this.xmlStreamWriter.writeAttribute(TYPE, rollbackResource.getType());
        if (rollbackResource.isMissing()) {
            this.xmlStreamWriter.writeAttribute(MISSING, TRUE);
        }
        if (rollbackResource.getDeployType() != null) {
            this.xmlStreamWriter.writeAttribute(DEPLOY_TYPE, rollbackResource.getDeployType());
        }
        if (rollbackResource.getModifiedUser() != null) {
            this.xmlStreamWriter.writeAttribute("lastModifiedUserid", rollbackResource.getModifiedUser());
        }
        if (rollbackResource.getModifiedTimestamp() != null) {
            this.xmlStreamWriter.writeAttribute("lastModifiedTimestamp", rollbackResource.getModifiedTimestamp());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingTag(String elementName) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(elementName);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeEndingTag() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

